package com.proximities.sdk.json.model.transmitter;

import android.os.Parcel;
import android.os.Parcelable;

import com.proximities.sdk.json.model.partner.Poi;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 28/12/14.
 */
public class Campaign implements Parcelable {

    private int id;
    private String title;
    private String type;
    private String templateType;
    private String identifier;
    private String topbarTitle;
    private String topbarBackgroundColor;
    private String topbarFontColor;
    private String contentTitle;
    private String contentText;
    private String contentBackgroundColor;
    private String contentFontColor;
    private String banner;
    private String image;
    private String bannerOffline;
    private String imageOffline;
    private String webviewUrl;
    private String media;
    private String startDate;
    private String endDate;
    private Poi poi; // set programmaticaly
    private String poiName;
    private int timeLeft;
    private int locked;
    private int favorite;
    private String topbarButton;
    private int nbStamps;
    private int userStamps;

    public Campaign(){
    }

    public String getTopbarButton() {
        return topbarButton;
    }
    public void setTopbarButton(String topbarButton) {
        this.topbarButton = topbarButton;
    }
    public int getFavorite() {
        return favorite;
    }
    public int getTimeLeft() {
        return timeLeft;
    }
    public void setTimeLeft(int timeLeft) {
        this.timeLeft = timeLeft;
    }
    public int getLocked() {
        return locked;
    }
    public void setLocked(int locked) {
        this.locked = locked;
    }
    public Poi getPoi() {
        return poi;
    }
    public void setPoi(Poi poi) {
        this.poi = poi;
        this.poiName = poi.getName();
    }
    public String getPoiName() {
        return poiName;
    }
    public void setPoiName(String poiName) {
        this.poiName = poiName;
    }
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }
    public String getTitle() {
        return title;
    }
    public void setTitle(String title) {
        this.title = title;
    }
    public String getType() {
        return type;
    }
    public void setType(String type) {
        this.type = type;
    }
    public String getTemplateType() {
        return templateType;
    }
    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }
    public String getIdentifier() {
        return identifier;
    }
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
    public String getTopbarTitle() {
        return topbarTitle;
    }
    public void setTopbarTitle(String topbarTitle) {
        this.topbarTitle = topbarTitle;
    }
    public String getTopbarBackgroundColor() {
        return topbarBackgroundColor;
    }
    public void setTopbarBackgroundColor(String topbarBackgroundColor) {
        this.topbarBackgroundColor = topbarBackgroundColor;
    }
    public String getTopbarFontColor() {
        return topbarFontColor;
    }
    public void setTopbarFontColor(String topbarFontColor) {
        this.topbarFontColor = topbarFontColor;
    }
    public String getContentTitle() {
        return contentTitle;
    }
    public void setContentTitle(String contentTitle) {
        this.contentTitle = contentTitle;
    }
    public String getContentText() {
        return contentText;
    }
    public void setContentText(String contentText) {
        this.contentText = contentText;
    }
    public String getContentBackgroundColor() {
        return contentBackgroundColor;
    }
    public void setContentBackgroundColor(String contentBackgroundColor) {
        this.contentBackgroundColor = contentBackgroundColor;
    }
    public String getContentFontColor() {
        return contentFontColor;
    }
    public void setContentFontColor(String contentFontColor) {
        this.contentFontColor = contentFontColor;
    }
    public String getBanner() {
        return banner;
    }
    public void setBanner(String banner) {
        this.banner = banner;
    }
    public String getImage() {
        return image;
    }
    public void setImage(String image) {
        this.image = image;
    }
    public String getWebviewUrl() {
        return webviewUrl;
    }
    public void setWebviewUrl(String webviewUrl) {
        this.webviewUrl = webviewUrl;
    }
    public String getBannerOffline() {
        return bannerOffline;
    }
    public void setBannerOffline(String bannerOffline) {
        this.bannerOffline = bannerOffline;
    }
    public String getImageOffline() {
        return imageOffline;
    }
    public void setImageOffline(String imageOffline) {
        this.imageOffline = imageOffline;
    }
    public String getMedia() {
        return media;
    }
    public void setMedia(String media) {
        this.media = media;
    }
    public int getNbStamps() {
        return nbStamps;
    }
    public void setNbStamps(int nbStamps) {
        this.nbStamps = nbStamps;
    }
    public int getUserStamps() {
        return userStamps;
    }
    public void setUserStamps(int userStamps) {
        this.userStamps = userStamps;
    }
    public String getStartDate() {
        return startDate;
    }
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }
    public String getEndDate() {
        return endDate;
    }
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.id);
        dest.writeString(this.title);
        dest.writeString(this.type);
        dest.writeString(this.templateType);
        dest.writeString(this.identifier);
        dest.writeString(this.topbarTitle);
        dest.writeString(this.topbarBackgroundColor);
        dest.writeString(this.topbarFontColor);
        dest.writeString(this.contentTitle);
        dest.writeString(this.contentText);
        dest.writeString(this.contentBackgroundColor);
        dest.writeString(this.contentFontColor);
        dest.writeString(this.banner);
        dest.writeString(this.image);
        dest.writeString(this.bannerOffline);
        dest.writeString(this.imageOffline);
        dest.writeString(this.webviewUrl);
        dest.writeString(this.media);
        dest.writeString(this.poiName);
        dest.writeInt(this.locked);
        dest.writeInt(this.timeLeft);
        dest.writeInt(this.favorite);
        dest.writeString(this.topbarButton);
        dest.writeInt(this.nbStamps);
        dest.writeInt(this.userStamps);
        dest.writeString(this.startDate);
        dest.writeString(this.endDate);
    }

    private Campaign(Parcel in) {
        this.id = in.readInt();
        this.title = in.readString();
        this.type = in.readString();
        this.templateType = in.readString();
        this.identifier = in.readString();
        this.topbarTitle = in.readString();
        this.topbarBackgroundColor = in.readString();
        this.topbarFontColor = in.readString();
        this.contentTitle = in.readString();
        this.contentText = in.readString();
        this.contentBackgroundColor = in.readString();
        this.contentFontColor = in.readString();
        this.banner = in.readString();
        this.image = in.readString();
        this.bannerOffline = in.readString();
        this.imageOffline = in.readString();
        this.webviewUrl = in.readString();
        this.media = in.readString();
        this.poiName = in.readString();
        this.locked = in.readInt();
        this.timeLeft = in.readInt();
        this.favorite = in.readInt();
        this.topbarButton = in.readString();
        this.nbStamps = in.readInt();
        this.userStamps = in.readInt();
        this.startDate = in.readString();
        this.endDate = in.readString();
    }

    public static final Creator<Campaign> CREATOR = new Creator<Campaign>() {
        public Campaign createFromParcel(Parcel source) {
            return new Campaign(source);
        }

        public Campaign[] newArray(int size) {
            return new Campaign[size];
        }
    };
}
