package com.proximities.sdk.fragment.dialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;

import android.os.Bundle;
import android.support.v4.app.DialogFragment;

import com.proximities.sdk.R;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 05/02/15.
 */
public class DelListAnimFragment extends DialogFragment {

    private static DelAnimListListener delCallback;

    public interface DelAnimListListener {
        public void onClikDelList();
    }

    public static DelListAnimFragment newInstance() {
        DelListAnimFragment dlg = new DelListAnimFragment();
        return dlg;
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            delCallback = (DelAnimListListener) activity;
        } catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement DelAnimListListener");
        }
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
        builder.setTitle(R.string.dismiss_multiple_anim_title)
                .setMessage(R.string.dismiss_multiple_anim)
                .setNegativeButton(R.string.disagree, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int id) {
                    }
                })
                .setPositiveButton(R.string.agree, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int id) {
                        delCallback.onClikDelList();
                    }
                });
        return builder.create();
    }
}