package com.proximities.sdk.fragment.dialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;

import com.proximities.sdk.R;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 17/01/15.
 */
public class DelAnimFragment extends DialogFragment {

    private static DelAnimListener delCallback;

    public interface DelAnimListener {
        public void onClikDel();
    }

    public static DelAnimFragment newInstance() {
        DelAnimFragment dlg = new DelAnimFragment();
        return dlg;
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            delCallback = (DelAnimListener) activity;
        } catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement DelAnimListener");
        }
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
        builder.setTitle(R.string.delete_animation)
                .setMessage(R.string.delete_animation_txt)
                .setNegativeButton(R.string.disagree, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int id) {
                    }
                })
                .setPositiveButton(R.string.agree, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int id) {
                        delCallback.onClikDel();
                    }
                });
        return builder.create();
    }
}
