package com.proximities.sdk.fragment;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.ColorUtils;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;

import com.proximities.sdk.ProximitiesConfig;
import com.proximities.sdk.R;
import com.proximities.sdk.bridge.OnUrlRequestListener;
import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.util.ProximitiesConstants;
import com.proximities.sdk.util.ProximitiesPrefs;

import java.util.concurrent.TimeUnit;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

/**
 * Created by william on 29/09/15.
 */
public class VideoAnimation extends Fragment implements TextureView.SurfaceTextureListener{

    private static OnUrlRequestListener urlRequestListener;
    private RelativeLayout textPart;
    private RelativeLayout mainLayout;
    private WebView content;
    private MediaPlayer mediaPlayer;
    private TextureView video;
    private ImageView playOrPause;
    private ImageView fullScreen;
    private TextView progressTime;
    private TextView duration;
    private TextView title;
    private SeekBar timeline;
    private ProgressBar spinner;
    private Campaign campaign;
    private boolean isAnimOpened = false;
    private boolean isVideoPrepared = false;
    private int timeElapsed = 0;
    private Handler durationHandler = new Handler();

    public static VideoAnimation newInstance(OnUrlRequestListener OnUrlRequestListener) {
        urlRequestListener = OnUrlRequestListener;
        return new VideoAnimation();
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.video_animation_fragment, container, false);
        mainLayout = (RelativeLayout) v.findViewById(R.id.main_layout);
        video = (TextureView) v.findViewById(R.id.video);
        video.setSurfaceTextureListener(this);
        textPart = (RelativeLayout) v.findViewById(R.id.text_part);
        progressTime = (TextView) v.findViewById(R.id.progress_time);
        duration = (TextView) v.findViewById(R.id.duration_media);
        timeline = (SeekBar) v.findViewById(R.id.timeline);
        content = (WebView) v.findViewById(R.id.content);
        playOrPause = (ImageView) v.findViewById(R.id.playOrPause);
        fullScreen = (ImageView) v.findViewById(R.id.full_screen);
        title = (TextView) v.findViewById(R.id.title);
        spinner = (ProgressBar) v.findViewById(R.id.spinner);
        //Typeface font = Typeface.createFromAsset(getActivity().getAssets(), "fontawesome-webfont.ttf");
        //playOrPause.setTypeface(font);
        //fullScreen.setTypeface(font);
        return v;
    }

    private void changeSeekbarColor(SeekBar s,int colorp, int colors) {
        try {
            PorterDuff.Mode mMode = PorterDuff.Mode.SRC_ATOP;
            LayerDrawable layerDrawable = (LayerDrawable) s.getProgressDrawable();
            Drawable progress = (Drawable) layerDrawable.findDrawableByLayerId(android.R.id.progress);
            Drawable secondary = (Drawable) layerDrawable.findDrawableByLayerId(android.R.id.background);
            if (getActivity().getResources().getConfiguration().orientation != Configuration.ORIENTATION_LANDSCAPE) {
                progress.setColorFilter(colorp, mMode);
                secondary.setColorFilter(colors, mMode);
            } else {
                progress.setColorFilter(ContextCompat.getColor(getActivity(), android.R.color.white), mMode);
                secondary.setColorFilter(ColorUtils.setAlphaComponent(ContextCompat.getColor(getActivity(), android.R.color.white), 0x77), mMode);
            }
            layerDrawable.setDrawableByLayerId(android.R.id.progress, progress);
            layerDrawable.setDrawableByLayerId(android.R.id.background, secondary);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * Retrieve informations sent by {@link com.proximities.sdk.ProximitiesAnimationActivity}
     *
     * @param data  {@link Campaign} object
     */
    @Subscribe(sticky = true)
    public void onEventMainThread(Campaign data) {
        if(!isAnimOpened) {
            campaign = data;
            isAnimOpened = true;
            if (campaign.getTemplateType() != null) {
                if (campaign.getTemplateType().equals(ProximitiesConstants.VIDEO_NOTIF)) {
                    displayVideoAnimation();
                }
            }
        }
    }

    private void displayVideoAnimation(){
        int textColor = ContextCompat.getColor(getActivity(),android.R.color.black);  // TODO define a default content font color
        if (campaign.getContentFontColor() != null && !campaign.getContentFontColor().isEmpty()) {
            textColor = Color.parseColor(campaign.getContentFontColor());
        }

        changeSeekbarColor(timeline, textColor, ColorUtils.setAlphaComponent(textColor, 0x77));

        if(getActivity().getResources().getConfiguration().orientation != Configuration.ORIENTATION_LANDSCAPE) {
            //playOrPause.setTextColor(textColor);
            playOrPause.setColorFilter(new PorterDuffColorFilter(textColor, PorterDuff.Mode.MULTIPLY));
            //fullScreen.setTextColor(textColor);
            fullScreen.setColorFilter(textColor);
            progressTime.setTextColor(textColor);
            duration.setTextColor(textColor);
        }else{
            textPart.setBackgroundColor(ColorUtils.setAlphaComponent(ContextCompat.getColor(getActivity(), android.R.color.black), 0x77));
        }

        if (campaign.getContentTitle() != null && !campaign.getContentTitle().isEmpty() && getActivity().getResources().getConfiguration().orientation != Configuration.ORIENTATION_LANDSCAPE) {
            //title.setVisibility(View.VISIBLE);
            title.setText(campaign.getContentTitle());
            title.setTextColor(textColor);
        } else {
            title.setVisibility(View.GONE);
        }

        if (campaign.getContentText() != null && !campaign.getContentText().isEmpty() && getActivity().getResources().getConfiguration().orientation != Configuration.ORIENTATION_LANDSCAPE) {
            content.setVisibility(View.VISIBLE);
            content.setBackgroundColor(Color.TRANSPARENT);
            String myHtml = "<html><head>"
                    + "<style type=\"text/css\">body{color: " + campaign.getContentFontColor() + ";}"
                    + "</style>"
                    + "</head>"
                    + "<body>"
                    + campaign.getContentText()
                    + "</body></html>";
            content.loadDataWithBaseURL(null, myHtml, "text/html", "UTF-8", null);
            content.setWebViewClient(new WebViewClient() {
                @Override
                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    if(Patterns.WEB_URL.matcher(url).matches()) {
                        boolean isUrlHandled = false;
                        if(ProximitiesConfig.getInstance() != null){
                            if(ProximitiesConfig.getOnCampaignURLClickListener() != null) isUrlHandled = ProximitiesConfig.getOnCampaignURLClickListener().onCampaignURLCLick(url);
                            else if (ProximitiesConfig.getOnItemWebViewClickListener() != null) isUrlHandled = ProximitiesConfig.getOnItemWebViewClickListener().onItemWebViewClick(url);
                        }
                        if(!isUrlHandled)
                            urlRequestListener.displayUrlView(url);
                    } else {
                        Intent callIntent = new Intent(Intent.ACTION_DIAL);
                        callIntent.setData(Uri.parse("tel:" + url));
                        startActivity(callIntent);
                    }
                    return true;
                }
            });
        } else {
            content.setVisibility(View.GONE);
        }

        if (campaign.getContentBackgroundColor() != null && !campaign.getContentBackgroundColor().isEmpty()) {
            video.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
            mainLayout.setBackgroundColor(Color.parseColor(campaign.getContentBackgroundColor()));
        }

        try {
            if(mediaPlayer == null || getActivity().getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
                textPart.bringToFront();
                mediaPlayer = new MediaPlayer();
                mediaPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);
                mediaPlayer.setDataSource(ProximitiesConstants.STATIC_CONTENT_HOST + campaign.getMedia());
                //mediaPlayer.setDataSource("http://staging.sweepin.fr/uploads/media/animations/encoded/test/output.m3u8");

                mediaPlayer.prepareAsync();

                mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {
                    @Override
                    public void onPrepared(MediaPlayer mp) {
                        isVideoPrepared = true;
                        duration.setText(formatTime(mp.getDuration()));
                        timeline.setMax(mp.getDuration());
                        if(ProximitiesPrefs.readTimeVideo(getActivity()) == 0) {
                            mediaPlayer.start();
                            mediaPlayer.pause();
                        } else {
                            timeElapsed = (int) ProximitiesPrefs.readTimeVideo(getActivity());
                            mediaPlayer.seekTo(timeElapsed);
                            play();
                        }
                        if(spinner != null)
                            spinner.setVisibility(View.GONE);
                    }
                });

                video.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        setPlayOrPause();
                    }
                });

                mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {
                    @Override
                    public void onCompletion(MediaPlayer mp) {
                        if (isVideoPrepared) {
                            progressTime.setText(formatTime(mp.getDuration()));
                            //playOrPause.setText(getResources().getString(R.string.icn_play));
                            playOrPause.setImageDrawable(ContextCompat.getDrawable(getActivity(), R.drawable.ic_play_media));
                        }
                    }
                });

                mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener() {
                    @Override
                    public boolean onError(MediaPlayer mp, int what, int extra) {
                        isVideoPrepared = false;
                        return false;
                    }
                });

                timeline.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
                    @Override
                    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                        if (isVideoPrepared) {
                            if (fromUser) {
                                mediaPlayer.seekTo(progress);
                                seekBar.setProgress(progress);
                            }
                        }
                    }

                    @Override
                    public void onStartTrackingTouch(SeekBar seekBar) {

                    }

                    @Override
                    public void onStopTrackingTouch(SeekBar seekBar) {

                    }
                });

                playOrPause.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        setPlayOrPause();
                    }
                });

                fullScreen.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (isVideoPrepared) {
                            ProximitiesPrefs.writeTimeVideo(getActivity(), timeElapsed);
                            if (getActivity().getResources().getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
                                getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
                            } else {
                                getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
                            }
                        }
                    }
                });
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPlayOrPause(){
        if (isVideoPrepared && mediaPlayer != null) {
            if (!mediaPlayer.isPlaying()) {
                play();
            } else {
                mediaPlayer.pause();
                timeElapsed = mediaPlayer.getCurrentPosition();
                //playOrPause.setText(getResources().getString(R.string.icn_play));
                playOrPause.setImageDrawable(ContextCompat.getDrawable(getActivity(), R.drawable.ic_play_media));
            }
        }
    }

    private String formatTime(long millis){
        String mn = "";
        String s = "";
        if(TimeUnit.MILLISECONDS.toMinutes(millis) < 10){
            mn = "0" + String.valueOf(TimeUnit.MILLISECONDS.toMinutes(millis));
        } else {
            mn = String.valueOf(TimeUnit.MILLISECONDS.toMinutes(millis));
        }
        if((TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis))) <  10){
            s = "0" + String.valueOf(TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
        } else {
            s = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
        }
        return mn+":"+s;
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int i, int i2) {
        Surface surface = new Surface(surfaceTexture);
        if(mediaPlayer != null)
            mediaPlayer.setSurface(surface);
    }

    public void play() {
        timeline.setProgress(timeElapsed);
        durationHandler.postDelayed(updateSeekBarTime, 100);
        //playOrPause.setText(getResources().getString(R.string.icn_pause));
        playOrPause.setImageDrawable(ContextCompat.getDrawable(getActivity(), R.drawable.ic_pause_media));
        mediaPlayer.start();
    }

    private Runnable updateSeekBarTime = new Runnable() {
        public void run() {
            if(mediaPlayer != null) {
                timeElapsed = mediaPlayer.getCurrentPosition();
                timeline.setProgress(timeElapsed);
                progressTime.setText(formatTime(timeElapsed));
                durationHandler.postDelayed(this, 100);
            }
        }
    };

    @Override
    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int i, int i2) {
    }

    @Override
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {

        if (mediaPlayer != null) {
            /*mediaPlayer.release();
            mediaPlayer = null;*/
        }
        return true;
    }

    @Override
    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    public void onStart() {
        super.onStart();
        if(!EventBus.getDefault().isRegistered(this))
            EventBus.getDefault().register(this);
    }

    @Override
    public void onPause() {
        EventBus.getDefault().unregister(this);
        super.onPause();
        if(mediaPlayer != null && playOrPause != null) {
            if(isVideoPrepared) {
                mediaPlayer.pause();
                //playOrPause.setText(getResources().getString(R.string.icn_play));
                playOrPause.setImageDrawable(ContextCompat.getDrawable(getActivity(), R.drawable.ic_play_media));
            }
        }

    }

    @Override
    public void onStop() {
        super.onStop();
        durationHandler.removeCallbacks(updateSeekBarTime);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if(mediaPlayer != null)
            mediaPlayer.release();
    }
}
