package com.proximities.sdk.fragment;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListView;

import com.proximities.sdk.R;
import com.proximities.sdk.adapter.AnimationListAdapter;
import com.proximities.sdk.bridge.OnAnimationListener;
import com.proximities.sdk.json.model.transmitter.Campaign;

import java.util.ArrayList;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

/**
 * Created by Antoine Arnoult <arnoult.antoine@gmail.com> on 30/12/14.
 */
public class AnimListFragment extends Fragment implements OnAnimationListener {

    private AnimationListAdapter adapter;
    //private RecyclerView recycler;
    private ListView listAnimations;
    private OnAnimationListener callBackToActivity;
    private ArrayList<Campaign> anims;

    public static AnimListFragment newInstance() {
        AnimListFragment fragment = new AnimListFragment();
        return fragment;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View v = inflater.inflate(R.layout.anim_list_fragment, container, false);
        //recycler = (RecyclerView) v.findViewById(R.id.recycler);
        listAnimations = (ListView) v.findViewById(R.id.list_animations);
        anims = new ArrayList<>();
        adapter = new AnimationListAdapter(getActivity(), anims);
        listAnimations.setAdapter(adapter);
        listAnimations.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                onClickAnimation(anims.get(position));
            }
        });
        return v;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        Activity activity = (Activity) context;
        try {
            callBackToActivity = (OnAnimationListener) activity;
        } catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement OnAnimationListener");
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if(!EventBus.getDefault().isRegistered(this))
            EventBus.getDefault().register(this);
        //recycler.setLayoutManager(new GridLayoutManager(getActivity(), 2));
    }

    @Override
    public void onPause() {
        EventBus.getDefault().unregister(this);
        super.onPause();
    }

    /**
     * Retrieve informations sent by {@link com.proximities.sdk.ProximitiesAnimationActivity}
     *
     * @param data  List of {@link Campaign} object
     */
    @Subscribe(sticky = true)
    public void onEventMainThread(ArrayList<Campaign> data) {
        anims.clear();
        anims.addAll(data);
        adapter.notifyDataSetChanged();
        //if(SpinnerDialog.getInstance() != null)
            //SpinnerDialog.getInstance().dismiss();
    }

    /*private void showSpinnerDialog(){
        SpinnerDialog fragment
                = SpinnerDialog.newInstance();
        Bundle bundle = new Bundle();
        bundle.putString("textDialog", getResources().getString(R.string.load_anim));
        fragment.setArguments(bundle);
        fragment.show(getActivity().getSupportFragmentManager(), "spinner_dialog");
    }*/

    @Override
    public void onClickAnimation(Campaign anim) {
        //showSpinnerDialog();
        callBackToActivity.onClickAnimation(anim);
    }
}
