/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.feedback;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.IApp;
import com.github.stkent.amplify.IDevice;
import com.github.stkent.amplify.IEnvironment;
import com.github.stkent.amplify.feedback.IFeedbackCollector;
import com.github.stkent.amplify.utils.StringUtils;

public final class AmazonAppStoreFeedbackCollector
implements IFeedbackCollector {
    private static final String AMAZON_APP_STORE_URL_PREFIX = "amzn://apps/android?p=";
    private static final String AMAZON_RETAIL_WEBSITE_URL_PREFIX = "http://www.amazon.com/gp/mas/dl/android?p=";
    @Nullable
    private final String overridePackageName;

    public AmazonAppStoreFeedbackCollector() {
        this.overridePackageName = null;
    }

    public AmazonAppStoreFeedbackCollector(@NonNull String overridePackageName) {
        this.overridePackageName = overridePackageName;
    }

    @Override
    public boolean tryCollectingFeedback(@NonNull Activity currentActivity, @NonNull IApp app, @NonNull IEnvironment environment, @NonNull IDevice device) {
        String packageName = StringUtils.defaultIfBlank(this.overridePackageName, currentActivity.getPackageName());
        try {
            currentActivity.startActivity(new Intent("android.intent.action.VIEW", this.getAmazonAppStoreUrl(packageName)));
            currentActivity.overridePendingTransition(0x10A0000, 0x10A0001);
            return true;
        }
        catch (ActivityNotFoundException ignored) {
            try {
                currentActivity.startActivity(new Intent("android.intent.action.VIEW", this.getAmazonRetailWebsiteUrl(packageName)));
                currentActivity.overridePendingTransition(0x10A0000, 0x10A0001);
                return true;
            }
            catch (ActivityNotFoundException ignored2) {
                return false;
            }
        }
    }

    @NonNull
    private Uri getAmazonAppStoreUrl(@NonNull String packageName) {
        return Uri.parse((String)(AMAZON_APP_STORE_URL_PREFIX + packageName));
    }

    @NonNull
    private Uri getAmazonRetailWebsiteUrl(@NonNull String packageName) {
        return Uri.parse((String)(AMAZON_RETAIL_WEBSITE_URL_PREFIX + packageName));
    }
}

