/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.feedback;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.IApp;
import com.github.stkent.amplify.IDevice;
import com.github.stkent.amplify.IEnvironment;
import com.github.stkent.amplify.feedback.IFeedbackCollector;
import com.github.stkent.amplify.tracking.Amplify;

public abstract class BaseEmailFeedbackCollector
implements IFeedbackCollector {
    @NonNull
    private final String[] recipients;

    @NonNull
    protected abstract String getSubjectLine(@NonNull IApp var1, @NonNull IEnvironment var2, @NonNull IDevice var3);

    @NonNull
    protected abstract String getBody(@NonNull IApp var1, @NonNull IEnvironment var2, @NonNull IDevice var3);

    public BaseEmailFeedbackCollector(String ... recipients) {
        this.recipients = recipients;
    }

    @Override
    public boolean tryCollectingFeedback(@NonNull Activity currentActivity, @NonNull IApp app, @NonNull IEnvironment environment, @NonNull IDevice device) {
        Intent emailIntent = this.getEmailIntent(app, environment, device);
        if (!environment.canHandleIntent(emailIntent)) {
            Amplify.getLogger().e("Unable to present email client chooser.");
            return false;
        }
        this.showFeedbackEmailChooser(currentActivity, emailIntent);
        return true;
    }

    @NonNull
    private Intent getEmailIntent(@NonNull IApp app, @NonNull IEnvironment environment, @NonNull IDevice device) {
        Intent result = new Intent("android.intent.action.SENDTO");
        result.setData(Uri.parse((String)"mailto:"));
        result.putExtra("android.intent.extra.EMAIL", this.recipients);
        result.putExtra("android.intent.extra.SUBJECT", this.getSubjectLine(app, environment, device));
        result.putExtra("android.intent.extra.TEXT", this.getBody(app, environment, device));
        return result;
    }

    private void showFeedbackEmailChooser(@NonNull Activity currentActivity, @NonNull Intent emailIntent) {
        currentActivity.startActivity(emailIntent);
        currentActivity.overridePendingTransition(0, 0);
    }
}

