/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.prompt.BasePromptView;
import com.github.stkent.amplify.prompt.DefaultLayoutPromptViewConfig;
import com.github.stkent.amplify.prompt.DefaultLayoutQuestionView;
import com.github.stkent.amplify.prompt.DefaultLayoutThanksView;
import com.github.stkent.amplify.prompt.interfaces.IPromptView;

public final class DefaultLayoutPromptView
extends BasePromptView<DefaultLayoutQuestionView, DefaultLayoutThanksView>
implements IPromptView {
    private static final String DEFAULT_LAYOUT_PROMPT_VIEW_CONFIG_KEY = "DEFAULT_LAYOUT_PROMPT_VIEW_CONFIG_KEY";
    private DefaultLayoutPromptViewConfig config;

    public DefaultLayoutPromptView(Context context) {
        this(context, null);
    }

    public DefaultLayoutPromptView(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public DefaultLayoutPromptView(Context context, @Nullable AttributeSet attributeSet, int defStyleAttr) {
        super(context, attributeSet, defStyleAttr);
        this.init(attributeSet);
    }

    public void applyConfig(@NonNull DefaultLayoutPromptViewConfig config) {
        if (this.isDisplayed()) {
            throw new IllegalStateException("Configuration cannot be changed after the prompt is first displayed.");
        }
        this.config = config;
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle result = new Bundle();
        result.putParcelable("SUPER_STATE_KEY", superState);
        result.putParcelable(DEFAULT_LAYOUT_PROMPT_VIEW_CONFIG_KEY, (Parcelable)this.config);
        return result;
    }

    @Override
    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        Bundle savedState = (Bundle)state;
        if (savedState != null) {
            Parcelable superSavedState = savedState.getParcelable("SUPER_STATE_KEY");
            super.onRestoreInstanceState(superSavedState);
            DefaultLayoutPromptViewConfig config = (DefaultLayoutPromptViewConfig)savedState.getParcelable(DEFAULT_LAYOUT_PROMPT_VIEW_CONFIG_KEY);
            if (config != null) {
                this.config = config;
            }
            this.restorePresenterState(superSavedState);
        }
    }

    @Override
    protected boolean isConfigured() {
        return true;
    }

    @Override
    @NonNull
    protected DefaultLayoutQuestionView getQuestionView() {
        return new DefaultLayoutQuestionView(this.getContext(), this.config);
    }

    @Override
    @NonNull
    protected DefaultLayoutThanksView getThanksView() {
        return new DefaultLayoutThanksView(this.getContext(), this.config);
    }

    private void init(@Nullable AttributeSet attributeSet) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.DefaultLayoutPromptView, 0, 0);
        this.config = new DefaultLayoutPromptViewConfig(typedArray);
        typedArray.recycle();
    }
}

