/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.IApp;

public final class App
implements IApp {
    @NonNull
    private final String name;
    @NonNull
    private final String versionName;
    private final int versionCode;
    private final long firstInstallTime;
    private final long lastUpdateTime;

    public App(@NonNull Context context) {
        PackageManager packageManager = context.getPackageManager();
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        PackageInfo packageInfo = this.getPackageInfo(context);
        this.name = applicationInfo.loadLabel(packageManager).toString();
        this.versionName = packageInfo.versionName;
        this.versionCode = packageInfo.versionCode;
        this.firstInstallTime = packageInfo.firstInstallTime;
        this.lastUpdateTime = packageInfo.lastUpdateTime;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public String getVersionName() {
        return this.versionName;
    }

    @Override
    public int getVersionCode() {
        return this.versionCode;
    }

    @Override
    public long getInstallTime() {
        return this.firstInstallTime;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @NonNull
    private PackageInfo getPackageInfo(@NonNull Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            return packageManager.getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return null;
        }
    }
}

