/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.annotation.SuppressLint;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleableRes;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.prompt.Question;
import com.github.stkent.amplify.prompt.Thanks;
import com.github.stkent.amplify.prompt.interfaces.IQuestion;
import com.github.stkent.amplify.prompt.interfaces.IThanks;
import com.github.stkent.amplify.utils.StringUtils;

public final class BasePromptViewConfig
implements Parcelable {
    private static final String DEFAULT_USER_OPINION_QUESTION_TITLE = "Enjoying the app?";
    private static final String DEFAULT_POSITIVE_FEEDBACK_QUESTION_TITLE = "Awesome! We'd love a Play Store review...";
    private static final String DEFAULT_CRITICAL_FEEDBACK_QUESTION_TITLE = "Bummer. Would you like to send feedback?";
    private static final String DEFAULT_USER_OPINION_QUESTION_POSITIVE_BUTTON_LABEL = "Yes!";
    private static final String DEFAULT_USER_OPINION_QUESTION_NEGATIVE_BUTTON_LABEL = "No";
    private static final String DEFAULT_FEEDBACK_QUESTION_POSITIVE_BUTTON_LABEL = "Sure thing!";
    private static final String DEFAULT_FEEDBACK_QUESTION_NEGATIVE_BUTTON_LABEL = "Not right now";
    private static final String DEFAULT_THANKS_TITLE = "Thanks for your feedback!";
    private static final int DEFAULT_INTEGER_VALUE_IF_UNDEFINED = Integer.MAX_VALUE;
    @Nullable
    private final String userOpinionQuestionTitle;
    @Nullable
    private final String userOpinionQuestionSubtitle;
    @Nullable
    private final String userOpinionQuestionPositiveButtonLabel;
    @Nullable
    private final String userOpinionQuestionNegativeButtonLabel;
    @Nullable
    private final String positiveFeedbackQuestionTitle;
    @Nullable
    private final String positiveFeedbackQuestionSubtitle;
    @Nullable
    private final String positiveFeedbackQuestionPositiveButtonLabel;
    @Nullable
    private final String positiveFeedbackQuestionNegativeButtonLabel;
    @Nullable
    private final String criticalFeedbackQuestionTitle;
    @Nullable
    private final String criticalFeedbackQuestionSubtitle;
    @Nullable
    private final String criticalFeedbackQuestionPositiveButtonLabel;
    @Nullable
    private final String criticalFeedbackQuestionNegativeButtonLabel;
    @Nullable
    private final String thanksTitle;
    @Nullable
    private final String thanksSubtitle;
    @Nullable
    private final Long thanksDisplayTimeMs;
    public static final Parcelable.Creator<BasePromptViewConfig> CREATOR = new Parcelable.Creator<BasePromptViewConfig>(){

        public BasePromptViewConfig createFromParcel(Parcel in) {
            return new BasePromptViewConfig(in);
        }

        public BasePromptViewConfig[] newArray(int size) {
            return new BasePromptViewConfig[size];
        }
    };

    @Nullable
    private static Long suppliedLongOrNull(@Nullable TypedArray typedArray, @StyleableRes int index) {
        if (typedArray != null) {
            int integer2 = typedArray.getInt(index, Integer.MAX_VALUE);
            return integer2 != Integer.MAX_VALUE ? Long.valueOf(integer2) : null;
        }
        return null;
    }

    public BasePromptViewConfig(@NonNull TypedArray typedArray) {
        this.userOpinionQuestionTitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_user_opinion_question_title);
        this.userOpinionQuestionSubtitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_user_opinion_question_subtitle);
        this.userOpinionQuestionPositiveButtonLabel = typedArray.getString(R.styleable.BasePromptView_prompt_view_user_opinion_question_positive_button_label);
        this.userOpinionQuestionNegativeButtonLabel = typedArray.getString(R.styleable.BasePromptView_prompt_view_user_opinion_question_negative_button_label);
        this.positiveFeedbackQuestionTitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_positive_feedback_question_title);
        this.positiveFeedbackQuestionSubtitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_positive_feedback_question_subtitle);
        this.positiveFeedbackQuestionPositiveButtonLabel = typedArray.getString(R.styleable.BasePromptView_prompt_view_positive_feedback_question_positive_button_label);
        this.positiveFeedbackQuestionNegativeButtonLabel = typedArray.getString(R.styleable.BasePromptView_prompt_view_positive_feedback_question_negative_button_label);
        this.criticalFeedbackQuestionTitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_critical_feedback_question_title);
        this.criticalFeedbackQuestionSubtitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_critical_feedback_question_subtitle);
        this.criticalFeedbackQuestionPositiveButtonLabel = typedArray.getString(R.styleable.BasePromptView_prompt_view_critical_feedback_question_positive_button_label);
        this.criticalFeedbackQuestionNegativeButtonLabel = typedArray.getString(R.styleable.BasePromptView_prompt_view_critical_feedback_question_negative_button_label);
        this.thanksTitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_thanks_title);
        this.thanksSubtitle = typedArray.getString(R.styleable.BasePromptView_prompt_view_thanks_subtitle);
        this.thanksDisplayTimeMs = BasePromptViewConfig.suppliedLongOrNull(typedArray, R.styleable.BasePromptView_prompt_view_thanks_display_time_ms);
    }

    protected BasePromptViewConfig(@Nullable String userOpinionQuestionTitle, @Nullable String userOpinionQuestionSubtitle, @Nullable String userOpinionQuestionPositiveButtonLabel, @Nullable String userOpinionQuestionNegativeButtonLabel, @Nullable String positiveFeedbackQuestionTitle, @Nullable String positiveFeedbackQuestionSubtitle, @Nullable String positiveFeedbackQuestionPositiveButtonLabel, @Nullable String positiveFeedbackQuestionNegativeButtonLabel, @Nullable String criticalFeedbackQuestionTitle, @Nullable String criticalFeedbackQuestionSubtitle, @Nullable String criticalFeedbackQuestionPositiveButtonLabel, @Nullable String criticalFeedbackQuestionNegativeButtonLabel, @Nullable String thanksTitle, @Nullable String thanksSubtitle, @Nullable Long thanksDisplayTimeMs) {
        this.userOpinionQuestionTitle = userOpinionQuestionTitle;
        this.userOpinionQuestionSubtitle = userOpinionQuestionSubtitle;
        this.userOpinionQuestionPositiveButtonLabel = userOpinionQuestionPositiveButtonLabel;
        this.userOpinionQuestionNegativeButtonLabel = userOpinionQuestionNegativeButtonLabel;
        this.positiveFeedbackQuestionTitle = positiveFeedbackQuestionTitle;
        this.positiveFeedbackQuestionSubtitle = positiveFeedbackQuestionSubtitle;
        this.positiveFeedbackQuestionPositiveButtonLabel = positiveFeedbackQuestionPositiveButtonLabel;
        this.positiveFeedbackQuestionNegativeButtonLabel = positiveFeedbackQuestionNegativeButtonLabel;
        this.criticalFeedbackQuestionTitle = criticalFeedbackQuestionTitle;
        this.criticalFeedbackQuestionSubtitle = criticalFeedbackQuestionSubtitle;
        this.criticalFeedbackQuestionPositiveButtonLabel = criticalFeedbackQuestionPositiveButtonLabel;
        this.criticalFeedbackQuestionNegativeButtonLabel = criticalFeedbackQuestionNegativeButtonLabel;
        this.thanksTitle = thanksTitle;
        this.thanksSubtitle = thanksSubtitle;
        this.thanksDisplayTimeMs = thanksDisplayTimeMs;
    }

    @NonNull
    public IQuestion getUserOpinionQuestion() {
        return new Question(this.getUserOpinionQuestionTitle(), this.userOpinionQuestionSubtitle, this.getUserOpinionQuestionPositiveButtonLabel(), this.getUserOpinionQuestionNegativeButtonLabel());
    }

    @NonNull
    public IQuestion getPositiveFeedbackQuestion() {
        return new Question(this.getPositiveFeedbackQuestionTitle(), this.positiveFeedbackQuestionSubtitle, this.getPositiveFeedbackQuestionPositiveButtonLabel(), this.getPositiveFeedbackQuestionNegativeButtonLabel());
    }

    @NonNull
    public IQuestion getCriticalFeedbackQuestion() {
        return new Question(this.getCriticalFeedbackQuestionTitle(), this.criticalFeedbackQuestionSubtitle, this.getCriticalFeedbackQuestionPositiveButtonLabel(), this.getCriticalFeedbackQuestionNegativeButtonLabel());
    }

    @NonNull
    public IThanks getThanks() {
        return new Thanks(this.getThanksTitle(), this.thanksSubtitle);
    }

    @Nullable
    public Long getThanksDisplayTimeMs() {
        return this.thanksDisplayTimeMs;
    }

    @NonNull
    private String getUserOpinionQuestionTitle() {
        return StringUtils.defaultIfBlank(this.userOpinionQuestionTitle, DEFAULT_USER_OPINION_QUESTION_TITLE);
    }

    @NonNull
    private String getUserOpinionQuestionPositiveButtonLabel() {
        return StringUtils.defaultIfBlank(this.userOpinionQuestionPositiveButtonLabel, DEFAULT_USER_OPINION_QUESTION_POSITIVE_BUTTON_LABEL);
    }

    @NonNull
    private String getUserOpinionQuestionNegativeButtonLabel() {
        return StringUtils.defaultIfBlank(this.userOpinionQuestionNegativeButtonLabel, DEFAULT_USER_OPINION_QUESTION_NEGATIVE_BUTTON_LABEL);
    }

    @NonNull
    private String getPositiveFeedbackQuestionTitle() {
        return StringUtils.defaultIfBlank(this.positiveFeedbackQuestionTitle, DEFAULT_POSITIVE_FEEDBACK_QUESTION_TITLE);
    }

    @NonNull
    private String getPositiveFeedbackQuestionPositiveButtonLabel() {
        return StringUtils.defaultIfBlank(this.positiveFeedbackQuestionPositiveButtonLabel, DEFAULT_FEEDBACK_QUESTION_POSITIVE_BUTTON_LABEL);
    }

    @NonNull
    private String getPositiveFeedbackQuestionNegativeButtonLabel() {
        return StringUtils.defaultIfBlank(this.positiveFeedbackQuestionNegativeButtonLabel, DEFAULT_FEEDBACK_QUESTION_NEGATIVE_BUTTON_LABEL);
    }

    @NonNull
    private String getCriticalFeedbackQuestionTitle() {
        return StringUtils.defaultIfBlank(this.criticalFeedbackQuestionTitle, DEFAULT_CRITICAL_FEEDBACK_QUESTION_TITLE);
    }

    @NonNull
    private String getCriticalFeedbackQuestionPositiveButtonLabel() {
        return StringUtils.defaultIfBlank(this.criticalFeedbackQuestionPositiveButtonLabel, DEFAULT_FEEDBACK_QUESTION_POSITIVE_BUTTON_LABEL);
    }

    @NonNull
    private String getCriticalFeedbackQuestionNegativeButtonLabel() {
        return StringUtils.defaultIfBlank(this.criticalFeedbackQuestionNegativeButtonLabel, DEFAULT_FEEDBACK_QUESTION_NEGATIVE_BUTTON_LABEL);
    }

    @NonNull
    private String getThanksTitle() {
        return StringUtils.defaultIfBlank(this.thanksTitle, DEFAULT_THANKS_TITLE);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.userOpinionQuestionTitle);
        dest.writeValue((Object)this.userOpinionQuestionSubtitle);
        dest.writeValue((Object)this.userOpinionQuestionPositiveButtonLabel);
        dest.writeValue((Object)this.userOpinionQuestionNegativeButtonLabel);
        dest.writeValue((Object)this.positiveFeedbackQuestionTitle);
        dest.writeValue((Object)this.positiveFeedbackQuestionSubtitle);
        dest.writeValue((Object)this.positiveFeedbackQuestionPositiveButtonLabel);
        dest.writeValue((Object)this.positiveFeedbackQuestionNegativeButtonLabel);
        dest.writeValue((Object)this.criticalFeedbackQuestionTitle);
        dest.writeValue((Object)this.criticalFeedbackQuestionSubtitle);
        dest.writeValue((Object)this.criticalFeedbackQuestionPositiveButtonLabel);
        dest.writeValue((Object)this.criticalFeedbackQuestionNegativeButtonLabel);
        dest.writeValue((Object)this.thanksTitle);
        dest.writeValue((Object)this.thanksSubtitle);
        dest.writeValue((Object)this.thanksDisplayTimeMs);
    }

    @SuppressLint(value={"ParcelClassLoader"})
    protected BasePromptViewConfig(@NonNull Parcel in) {
        this.userOpinionQuestionTitle = (String)in.readValue(null);
        this.userOpinionQuestionSubtitle = (String)in.readValue(null);
        this.userOpinionQuestionPositiveButtonLabel = (String)in.readValue(null);
        this.userOpinionQuestionNegativeButtonLabel = (String)in.readValue(null);
        this.positiveFeedbackQuestionTitle = (String)in.readValue(null);
        this.positiveFeedbackQuestionSubtitle = (String)in.readValue(null);
        this.positiveFeedbackQuestionPositiveButtonLabel = (String)in.readValue(null);
        this.positiveFeedbackQuestionNegativeButtonLabel = (String)in.readValue(null);
        this.criticalFeedbackQuestionTitle = (String)in.readValue(null);
        this.criticalFeedbackQuestionSubtitle = (String)in.readValue(null);
        this.criticalFeedbackQuestionPositiveButtonLabel = (String)in.readValue(null);
        this.criticalFeedbackQuestionNegativeButtonLabel = (String)in.readValue(null);
        this.thanksTitle = (String)in.readValue(null);
        this.thanksSubtitle = (String)in.readValue(null);
        this.thanksDisplayTimeMs = (Long)in.readValue(null);
    }

    public static final class Builder {
        @Nullable
        private String userOpinionQuestionTitle;
        @Nullable
        private String userOpinionQuestionSubtitle;
        @Nullable
        private String userOpinionQuestionPositiveButtonLabel;
        @Nullable
        private String userOpinionQuestionNegativeButtonLabel;
        @Nullable
        private String positiveFeedbackQuestionTitle;
        @Nullable
        private String positiveFeedbackQuestionSubtitle;
        @Nullable
        private String positiveFeedbackQuestionPositiveButtonLabel;
        @Nullable
        private String positiveFeedbackQuestionNegativeButtonLabel;
        @Nullable
        private String criticalFeedbackQuestionTitle;
        @Nullable
        private String criticalFeedbackQuestionSubtitle;
        @Nullable
        private String criticalFeedbackQuestionPositiveButtonLabel;
        @Nullable
        private String criticalFeedbackQuestionNegativeButtonLabel;
        @Nullable
        private String thanksTitle;
        @Nullable
        private String thanksSubtitle;
        @Nullable
        private Long thanksDisplayTimeMs;

        public Builder setUserOpinionQuestionTitle(@NonNull String userOpinionQuestionTitle) {
            this.userOpinionQuestionTitle = userOpinionQuestionTitle;
            return this;
        }

        public Builder setUserOpinionQuestionSubtitle(@NonNull String userOpinionQuestionSubtitle) {
            this.userOpinionQuestionSubtitle = userOpinionQuestionSubtitle;
            return this;
        }

        public Builder setUserOpinionQuestionPositiveButtonLabel(@NonNull String userOpinionQuestionPositiveButtonLabel) {
            this.userOpinionQuestionPositiveButtonLabel = userOpinionQuestionPositiveButtonLabel;
            return this;
        }

        public Builder setUserOpinionQuestionNegativeButtonLabel(@NonNull String userOpinionQuestionNegativeButtonLabel) {
            this.userOpinionQuestionNegativeButtonLabel = userOpinionQuestionNegativeButtonLabel;
            return this;
        }

        public Builder setPositiveFeedbackQuestionTitle(@NonNull String positiveFeedbackQuestionTitle) {
            this.positiveFeedbackQuestionTitle = positiveFeedbackQuestionTitle;
            return this;
        }

        public Builder setPositiveFeedbackQuestionSubtitle(@NonNull String positiveFeedbackQuestionSubtitle) {
            this.positiveFeedbackQuestionSubtitle = positiveFeedbackQuestionSubtitle;
            return this;
        }

        public Builder setPositiveFeedbackQuestionPositiveButtonLabel(@NonNull String positiveFeedbackQuestionPositiveButtonLabel) {
            this.positiveFeedbackQuestionPositiveButtonLabel = positiveFeedbackQuestionPositiveButtonLabel;
            return this;
        }

        public Builder setPositiveFeedbackQuestionNegativeButtonLabel(@NonNull String positiveFeedbackQuestionNegativeButtonLabel) {
            this.positiveFeedbackQuestionNegativeButtonLabel = positiveFeedbackQuestionNegativeButtonLabel;
            return this;
        }

        public Builder setCriticalFeedbackQuestionTitle(@NonNull String criticalFeedbackQuestionTitle) {
            this.criticalFeedbackQuestionTitle = criticalFeedbackQuestionTitle;
            return this;
        }

        public Builder setCriticalFeedbackQuestionSubtitle(@NonNull String criticalFeedbackQuestionSubtitle) {
            this.criticalFeedbackQuestionSubtitle = criticalFeedbackQuestionSubtitle;
            return this;
        }

        public Builder setCriticalFeedbackQuestionPositiveButtonLabel(@NonNull String criticalFeedbackQuestionPositiveButtonLabel) {
            this.criticalFeedbackQuestionPositiveButtonLabel = criticalFeedbackQuestionPositiveButtonLabel;
            return this;
        }

        public Builder setCriticalFeedbackQuestionNegativeButtonLabel(@NonNull String criticalFeedbackQuestionNegativeButtonLabel) {
            this.criticalFeedbackQuestionNegativeButtonLabel = criticalFeedbackQuestionNegativeButtonLabel;
            return this;
        }

        public Builder setThanksTitle(@NonNull String thanksTitle) {
            this.thanksTitle = thanksTitle;
            return this;
        }

        public Builder setThanksSubtitle(@NonNull String thanksSubtitle) {
            this.thanksSubtitle = thanksSubtitle;
            return this;
        }

        public Builder setThanksDisplayTimeMs(int thanksDisplayTimeMs) {
            this.thanksDisplayTimeMs = thanksDisplayTimeMs;
            return this;
        }

        public BasePromptViewConfig build() {
            return new BasePromptViewConfig(this.userOpinionQuestionTitle, this.userOpinionQuestionSubtitle, this.userOpinionQuestionPositiveButtonLabel, this.userOpinionQuestionNegativeButtonLabel, this.positiveFeedbackQuestionTitle, this.positiveFeedbackQuestionSubtitle, this.positiveFeedbackQuestionPositiveButtonLabel, this.positiveFeedbackQuestionNegativeButtonLabel, this.criticalFeedbackQuestionTitle, this.criticalFeedbackQuestionSubtitle, this.criticalFeedbackQuestionPositiveButtonLabel, this.criticalFeedbackQuestionNegativeButtonLabel, this.thanksTitle, this.thanksSubtitle, this.thanksDisplayTimeMs);
        }
    }
}

