/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IAppFeedbackDataProvider;
import com.github.stkent.amplify.utils.StringUtils;
import com.github.stkent.amplify.utils.appinfo.IAppInfoProvider;

public final class AppFeedbackDataProvider
implements IAppFeedbackDataProvider {
    @NonNull
    private final IAppInfoProvider appInfoProvider;

    public AppFeedbackDataProvider(@NonNull IAppInfoProvider appInfoProvider) {
        this.appInfoProvider = appInfoProvider;
    }

    @Override
    @NonNull
    public String getDeviceName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        String deviceName = model.startsWith(manufacturer) ? model : manufacturer + " " + model;
        return StringUtils.capitalizeFully(deviceName);
    }

    @Override
    @NonNull
    public String getVersionDisplayString() {
        PackageInfo packageInfo = this.appInfoProvider.getPackageInfo();
        String applicationVersionName = packageInfo.versionName;
        int applicationVersionCode = packageInfo.versionCode;
        return String.format("%s (%s)", applicationVersionName, applicationVersionCode);
    }

    @Override
    @NonNull
    public CharSequence getAppNameString() {
        return this.appInfoProvider.getApplicationInfo().loadLabel(this.appInfoProvider.getPackageManager());
    }
}

