/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.Intent;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentCapabilitiesProvider;
import com.github.stkent.amplify.utils.appinfo.IAppInfoProvider;
import java.util.List;

public final class EnvironmentCapabilitiesProvider
implements IEnvironmentCapabilitiesProvider {
    private static final String GOOGLE_PLAY_STORE_PACKAGE_NAME = "com.android.vending";
    @NonNull
    private final IAppInfoProvider appInfoProvider;

    public EnvironmentCapabilitiesProvider(@NonNull IAppInfoProvider appInfoProvider) {
        this.appInfoProvider = appInfoProvider;
    }

    @Override
    public boolean isAppInstalled(@NonNull String packageName) {
        return this.appInfoProvider.getPackageInfo(packageName, 1) != null;
    }

    @Override
    public boolean isGooglePlayStoreInstalled() {
        return this.isAppInstalled(GOOGLE_PLAY_STORE_PACKAGE_NAME);
    }

    @Override
    public boolean canHandleIntent(@NonNull Intent intent) {
        List resolveInfoList = this.appInfoProvider.getPackageManager().queryIntentActivities(intent, 65536);
        return !resolveInfoList.isEmpty();
    }
}

