/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.rules;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;
import com.github.stkent.amplify.utils.time.SystemTimeUtil;
import java.util.concurrent.TimeUnit;

public class WarmupDaysRule
implements IEventBasedRule<Long> {
    private final long warmupPeriodDays;

    public WarmupDaysRule(long warmupPeriodDays) {
        this.warmupPeriodDays = warmupPeriodDays;
    }

    @Override
    public boolean shouldAllowFeedbackPromptByDefault() {
        return false;
    }

    @Override
    public boolean shouldAllowFeedbackPrompt(@NonNull Long cachedEventValue) {
        return SystemTimeUtil.currentTimeMillis() - cachedEventValue > TimeUnit.DAYS.toMillis(this.warmupPeriodDays);
    }

    @Override
    @NonNull
    public String getDescription() {
        return "WarmupDaysRule with a warmup period of " + this.warmupPeriodDays + " day" + (this.warmupPeriodDays > 1L ? "s" : "");
    }
}

