/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.rules;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;
import com.github.stkent.amplify.utils.time.SystemTimeUtil;
import java.util.concurrent.TimeUnit;

public final class CooldownDaysRule
implements IEventBasedRule<Long> {
    private final long cooldownPeriodDays;

    public CooldownDaysRule(long cooldownPeriodDays) {
        this.cooldownPeriodDays = cooldownPeriodDays;
    }

    @Override
    public boolean shouldAllowFeedbackPromptByDefault() {
        return true;
    }

    @Override
    public boolean shouldAllowFeedbackPrompt(@NonNull Long cachedEventValue) {
        return SystemTimeUtil.currentTimeMillis() - cachedEventValue >= TimeUnit.DAYS.toMillis(this.cooldownPeriodDays);
    }

    @Override
    @NonNull
    public String getDescription() {
        return "CooldownDaysRule with a cooldown period of " + this.cooldownPeriodDays + " day" + (this.cooldownPeriodDays > 1L ? "s" : "");
    }
}

