/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify;

import android.support.annotation.NonNull;
import android.util.Log;
import com.github.stkent.amplify.ILogger;

public final class Logger
implements ILogger {
    private static final String TAG = "Amplify Library";
    private LogLevel logLevel = LogLevel.ERROR;

    @Override
    public void setLogLevel(@NonNull LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void d(@NonNull String message) {
        if (this.logLevel.getVerbosity() >= LogLevel.DEBUG.getVerbosity()) {
            Log.d((String)TAG, (String)message);
        }
    }

    @Override
    public void e(@NonNull String message) {
        if (this.logLevel.getVerbosity() >= LogLevel.ERROR.getVerbosity()) {
            Log.e((String)TAG, (String)message);
        }
    }

    public static enum LogLevel {
        NONE(0),
        ERROR(1),
        DEBUG(2);

        private final int verbosity;

        private LogLevel(int verbosity) {
            this.verbosity = verbosity;
        }

        public int getVerbosity() {
            return this.verbosity;
        }
    }
}

