/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.rules;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;
import com.github.stkent.amplify.utils.time.SystemTimeUtil;
import java.util.concurrent.TimeUnit;

public class WarmupDaysRule
implements IEventBasedRule<Long> {
    private final long warmupPeriodDays;

    public WarmupDaysRule(long warmupPeriodDays) {
        this.warmupPeriodDays = warmupPeriodDays;
    }

    @Override
    public boolean shouldAllowFeedbackPrompt(@NonNull Long cachedEventValue) {
        return cachedEventValue != Long.MAX_VALUE && SystemTimeUtil.currentTimeMillis() - cachedEventValue > TimeUnit.DAYS.toMillis(this.warmupPeriodDays);
    }

    @Override
    @NonNull
    public String getStatusString(@NonNull Long cachedEventValue) {
        Long daysSinceFirstEvent = TimeUnit.MILLISECONDS.toDays(SystemTimeUtil.currentTimeMillis() - cachedEventValue);
        return "Warmup period: " + this.warmupPeriodDays + " days. Time since first event: " + daysSinceFirstEvent + " days.";
    }
}

