/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.managers;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.tracking.interfaces.IEvent;
import com.github.stkent.amplify.tracking.interfaces.IEventBasedRule;
import com.github.stkent.amplify.tracking.interfaces.IEventsManager;
import com.github.stkent.amplify.tracking.interfaces.ISettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseEventsManager<T>
implements IEventsManager<T> {
    private static final String AMPLIFY_TRACKING_KEY_PREFIX = "AMPLIFY_";
    private final ILogger logger;
    private final ISettings<T> settings;
    private final ConcurrentHashMap<IEvent, List<IEventBasedRule<T>>> internalMap;

    @NonNull
    protected abstract String getTrackingKeySuffix();

    @NonNull
    protected abstract T defaultTrackingValue();

    @NonNull
    protected abstract T getUpdatedTrackingValue(@NonNull T var1);

    protected BaseEventsManager(@NonNull ILogger logger, @NonNull ISettings<T> settings) {
        this.logger = logger;
        this.settings = settings;
        this.internalMap = new ConcurrentHashMap();
    }

    @Override
    public void addEventBasedRule(@NonNull IEvent event, @NonNull IEventBasedRule<T> rule) {
        if (!this.isTrackingEvent(event)) {
            this.internalMap.put(event, new ArrayList());
        }
        this.internalMap.get(event).add(rule);
        this.logger.d(this.internalMap.get(event).toString());
    }

    @Override
    public void notifyEventTriggered(@NonNull IEvent event) {
        if (this.isTrackingEvent(event)) {
            T cachedTrackingValue = this.getCachedTrackingValue(event);
            T updatedTrackingValue = this.getUpdatedTrackingValue(cachedTrackingValue);
            if (!updatedTrackingValue.equals(cachedTrackingValue)) {
                this.logger.d(IEventBasedRule.class.getSimpleName() + " updating event value from: " + cachedTrackingValue + " to " + updatedTrackingValue);
            }
            this.settings.writeTrackingValue(this.getTrackingKey(event), updatedTrackingValue);
        }
    }

    @Override
    public boolean shouldAllowFeedbackPrompt() {
        for (Map.Entry<IEvent, List<IEventBasedRule<T>>> eventBasedRules : this.internalMap.entrySet()) {
            IEvent event = eventBasedRules.getKey();
            for (IEventBasedRule<T> eventBasedRule : eventBasedRules.getValue()) {
                T cachedEventValue = this.getCachedTrackingValue(event);
                this.logger.d(this.getTrackingKey(event) + ": " + eventBasedRule.getStatusString(cachedEventValue));
                if (eventBasedRule.shouldAllowFeedbackPrompt(cachedEventValue)) continue;
                this.logger.d("Blocking feedback for event: " + event + " because of check: " + eventBasedRule);
                return false;
            }
        }
        return true;
    }

    protected ILogger getLogger() {
        return this.logger;
    }

    private boolean isTrackingEvent(@NonNull IEvent event) {
        return this.internalMap.containsKey(event);
    }

    private String getTrackingKey(@NonNull IEvent event) {
        return AMPLIFY_TRACKING_KEY_PREFIX + event.getTrackingKey() + "_" + this.getTrackingKeySuffix().toUpperCase();
    }

    private T getCachedTrackingValue(@NonNull IEvent event) {
        T value = this.settings.readTrackingValue(this.getTrackingKey(event));
        return value != null ? value : this.defaultTrackingValue();
    }
}

