/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.prompt;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.github.stkent.amplify.R;
import com.github.stkent.amplify.prompt.BasePromptView;
import com.github.stkent.amplify.prompt.DefaultLayoutPromptViewConfig;
import com.github.stkent.amplify.prompt.DefaultLayoutQuestionView;
import com.github.stkent.amplify.prompt.DefaultLayoutThanksView;
import com.github.stkent.amplify.prompt.interfaces.IPromptView;

public final class DefaultLayoutPromptView
extends BasePromptView<DefaultLayoutQuestionView, DefaultLayoutThanksView>
implements IPromptView {
    private DefaultLayoutPromptViewConfig config;

    public DefaultLayoutPromptView(Context context) {
        this(context, null);
    }

    public DefaultLayoutPromptView(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public DefaultLayoutPromptView(Context context, @Nullable AttributeSet attributeSet, int defStyleAttr) {
        super(context, attributeSet, defStyleAttr);
        this.init(attributeSet);
    }

    public void applyConfig(@NonNull DefaultLayoutPromptViewConfig config) {
        if (this.isDisplayed()) {
            throw new IllegalStateException("Configuration cannot be changed after the prompt is first displayed.");
        }
        this.config = config;
    }

    @Override
    protected boolean isConfigured() {
        return true;
    }

    @Override
    @NonNull
    protected DefaultLayoutQuestionView getQuestionView() {
        return new DefaultLayoutQuestionView(this.getContext(), this.config);
    }

    @Override
    @NonNull
    protected DefaultLayoutThanksView getThanksView() {
        return new DefaultLayoutThanksView(this.getContext(), this.config);
    }

    private void init(@Nullable AttributeSet attributeSet) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.DefaultLayoutPromptView, 0, 0);
        this.config = new DefaultLayoutPromptViewConfig(typedArray);
        typedArray.recycle();
    }
}

