/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.managers;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.tracking.AmplifyExceptionHandler;
import com.github.stkent.amplify.tracking.checks.CooldownDaysCheck;
import com.github.stkent.amplify.tracking.interfaces.IApplicationChecksManager;
import com.github.stkent.amplify.tracking.interfaces.IApplicationEventTimeProvider;
import com.github.stkent.amplify.tracking.interfaces.IEventCheck;
import com.github.stkent.amplify.tracking.interfaces.ITrackableEvent;
import com.github.stkent.amplify.tracking.interfaces.ITrackableEventsManager;
import com.github.stkent.amplify.tracking.managers.LastEventTimesManager;

public class ApplicationChecksManager
implements IApplicationChecksManager {
    private static final ITrackableEvent APP_CRASHED = new ITrackableEvent(){

        @Override
        @NonNull
        public String getTrackingKey() {
            return "APP_CRASHED";
        }
    };
    @NonNull
    private final Context applicationContext;
    @NonNull
    private final ILogger logger;
    @NonNull
    private final IApplicationEventTimeProvider applicationInfoProvider;
    @Nullable
    private IEventCheck<Long> installTimeEventCheck;
    @Nullable
    private IEventCheck<Long> lastUpdateTimeTimeEventCheck;
    @Nullable
    private ITrackableEventsManager<Long> lastCrashTimeManager;

    public ApplicationChecksManager(@NonNull Context applicationContext, @NonNull IApplicationEventTimeProvider applicationInfoProvider, @NonNull ILogger logger) {
        this.applicationContext = applicationContext;
        this.applicationInfoProvider = applicationInfoProvider;
        this.logger = logger;
    }

    @Override
    public boolean shouldAllowFeedbackPrompt() {
        boolean result = true;
        if (this.installTimeEventCheck != null) {
            long installTime = this.applicationInfoProvider.getInstallTime();
            boolean bl = result = result && this.installTimeEventCheck.shouldAllowFeedbackPrompt(installTime);
        }
        if (this.lastUpdateTimeTimeEventCheck != null) {
            long lastUpdateTime = this.applicationInfoProvider.getLastUpdateTime();
            boolean bl = result = result && this.lastUpdateTimeTimeEventCheck.shouldAllowFeedbackPrompt(lastUpdateTime);
        }
        if (this.lastCrashTimeManager != null) {
            result = result && this.lastCrashTimeManager.shouldAllowFeedbackPrompt();
        }
        return result;
    }

    @Override
    public void setInstallTimeCooldownDays(int cooldownPeriodDays) {
        this.installTimeEventCheck = new CooldownDaysCheck(cooldownPeriodDays);
    }

    @Override
    public void setLastUpdateTimeCooldownDays(int cooldownPeriodDays) {
        this.lastUpdateTimeTimeEventCheck = new CooldownDaysCheck(cooldownPeriodDays);
    }

    @Override
    public void setLastCrashTimeCooldownDays(int cooldownPeriodDays) {
        this.lastCrashTimeManager = new LastEventTimesManager(this.applicationContext, this.logger);
        this.lastCrashTimeManager.trackEvent(APP_CRASHED, new CooldownDaysCheck(cooldownPeriodDays));
        Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (!(defaultUncaughtExceptionHandler instanceof AmplifyExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new AmplifyExceptionHandler(this, Thread.getDefaultUncaughtExceptionHandler()));
        }
    }

    @Override
    public void notifyOfCrash() {
        if (this.lastCrashTimeManager == null) {
            throw new IllegalStateException("The last crash time manager must be initialized before any app crashes can be reported.");
        }
        this.lastCrashTimeManager.notifyEventTriggered(APP_CRASHED);
    }
}

