/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.checks;

import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IApplicationVersionNameProvider;
import com.github.stkent.amplify.tracking.interfaces.IEventCheck;

public final class VersionChangedCheck
implements IEventCheck<String> {
    @NonNull
    private final IApplicationVersionNameProvider applicationVersionNameProvider;

    public VersionChangedCheck(@NonNull IApplicationVersionNameProvider applicationVersionNameProvider) {
        this.applicationVersionNameProvider = applicationVersionNameProvider;
    }

    @Override
    public boolean shouldAllowFeedbackPrompt(@NonNull String cachedEventValue) {
        try {
            String currentAppVersion = this.applicationVersionNameProvider.getVersionName();
            return !cachedEventValue.equals(currentAppVersion);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    @Override
    @NonNull
    public String getStatusString(@NonNull String cachedEventValue) {
        String statusStringSuffix;
        try {
            statusStringSuffix = "Current app version: " + this.applicationVersionNameProvider.getVersionName();
        }
        catch (PackageManager.NameNotFoundException e) {
            statusStringSuffix = "Current app version cannot be determined.";
        }
        return "Event last triggered for app version " + cachedEventValue + ". " + statusStringSuffix;
    }
}

