/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking.trackers;

import android.support.annotation.NonNull;
import com.github.stkent.amplify.ILogger;
import com.github.stkent.amplify.tracking.interfaces.IApplicationInfoProvider;
import com.github.stkent.amplify.tracking.interfaces.IEvent;
import com.github.stkent.amplify.tracking.interfaces.IEventCheck;
import com.github.stkent.amplify.tracking.interfaces.ISettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EventTracker<T> {
    private static final String AMPLIFY_TRACKING_KEY_PREFIX = "AMPLIFY_";
    private final ILogger logger;
    private final IApplicationInfoProvider applicationInfoProvider;
    private final ISettings<T> settings;
    private final ConcurrentHashMap<IEvent, List<IEventCheck<T>>> internalMap;

    @NonNull
    protected abstract String getTrackingKeySuffix();

    @NonNull
    protected abstract T defaultTrackingValue();

    @NonNull
    protected abstract T getUpdatedTrackingValue(@NonNull T var1);

    public EventTracker(@NonNull ILogger logger, @NonNull ISettings<T> settings, @NonNull IApplicationInfoProvider applicationInfoProvider) {
        this.logger = logger;
        this.settings = settings;
        this.applicationInfoProvider = applicationInfoProvider;
        this.internalMap = new ConcurrentHashMap();
    }

    public void trackEvent(@NonNull IEvent event, @NonNull IEventCheck<T> eventCheck) {
        if (!this.containsEvent(event)) {
            this.internalMap.put(event, new ArrayList());
        }
        this.internalMap.get(event).add(eventCheck);
        this.logger.d(this.internalMap.get(event).toString());
    }

    public void notifyEventTriggered(@NonNull IEvent event) {
        if (this.containsEvent(event)) {
            T cachedTrackingValue = this.getCachedTrackingValue(event);
            T updatedTrackingValue = this.getUpdatedTrackingValue(cachedTrackingValue);
            if (!updatedTrackingValue.equals(cachedTrackingValue)) {
                this.logger.d(IEventCheck.class.getSimpleName() + " updating event value from: " + cachedTrackingValue + " to " + updatedTrackingValue);
            }
            this.settings.writeTrackingValue(this.getTrackingKey(event), updatedTrackingValue);
        }
    }

    public boolean allowFeedbackPrompt() {
        for (Map.Entry<IEvent, List<IEventCheck<T>>> eventCheckSet : this.internalMap.entrySet()) {
            IEvent event = eventCheckSet.getKey();
            for (IEventCheck<T> eventCheck : eventCheckSet.getValue()) {
                T cachedEventValue = this.getCachedTrackingValue(event);
                this.logger.d(this.getTrackingKey(event) + ": " + eventCheck.getStatusString(cachedEventValue, this.applicationInfoProvider));
                if (!eventCheck.shouldBlockFeedbackPrompt(cachedEventValue, this.applicationInfoProvider)) continue;
                this.logger.d("Blocking feedback for event: " + event + " because of check: " + eventCheck);
                return false;
            }
        }
        return true;
    }

    public boolean containsEvent(@NonNull IEvent event) {
        return this.internalMap.containsKey(event);
    }

    protected ILogger getLogger() {
        return this.logger;
    }

    protected IApplicationInfoProvider getApplicationInfoProvider() {
        return this.applicationInfoProvider;
    }

    private String getTrackingKey(@NonNull IEvent event) {
        return AMPLIFY_TRACKING_KEY_PREFIX + event.getTrackingKey() + "_" + this.getTrackingKeySuffix().toUpperCase();
    }

    private T getCachedTrackingValue(@NonNull IEvent event) {
        T value = this.settings.readTrackingValue(this.getTrackingKey(event));
        return value != null ? value : this.defaultTrackingValue();
    }
}

