/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.TrackingUtils;
import com.github.stkent.amplify.tracking.interfaces.IEventCheck;

public final class VersionChangedCheck
implements IEventCheck<String> {
    @Override
    public boolean shouldBlockFeedbackPrompt(@NonNull String cachedEventValue, @NonNull Context applicationContext) {
        try {
            String currentAppVersion = TrackingUtils.getAppVersionName(applicationContext);
            return !cachedEventValue.equals(currentAppVersion);
        }
        catch (PackageManager.NameNotFoundException e) {
            return true;
        }
    }

    @Override
    @NonNull
    public String getStatusString(@NonNull String cachedEventValue, @NonNull Context applicationContext) {
        String statusStringSuffix;
        try {
            statusStringSuffix = "Current app version: " + TrackingUtils.getAppVersionName(applicationContext);
        }
        catch (PackageManager.NameNotFoundException e) {
            statusStringSuffix = "Current app version cannot be determined.";
        }
        return "Event last triggered for app version " + cachedEventValue + ". " + statusStringSuffix;
    }
}

