/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.Context;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.AmplifyExceptionHandler;
import com.github.stkent.amplify.tracking.interfaces.IEvent;

public enum IntegratedEvent implements IEvent
{
    APP_CRASHED,
    APP_INSTALLED,
    APP_UPDATED,
    USER_GAVE_POSITIVE_FEEDBACK,
    USER_GAVE_NEGATIVE_FEEDBACK;


    @Override
    @NonNull
    public String getTrackingKey() {
        return this.name();
    }

    @Override
    public void performRelatedInitialization(@NonNull Context applicationContext) {
        if (this == APP_CRASHED) {
            Thread.UncaughtExceptionHandler defaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            if (defaultExceptionHandler instanceof AmplifyExceptionHandler) {
                return;
            }
            Thread.setDefaultUncaughtExceptionHandler(new AmplifyExceptionHandler(applicationContext, defaultExceptionHandler));
        }
    }
}

