/*
 * Decompiled with CFR 0.152.
 */
package com.github.stkent.amplify.tracking;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import com.github.stkent.amplify.tracking.interfaces.IEnvironmentCheck;

public class GooglePlayServicesIsAvailableCheck
implements IEnvironmentCheck {
    @Override
    public boolean isMet(@NonNull Context applicationContext) {
        boolean playServicesInstalled;
        PackageManager pm = applicationContext.getPackageManager();
        try {
            PackageInfo info = pm.getPackageInfo("com.android.vending", 1);
            String label = (String)info.applicationInfo.loadLabel(pm);
            playServicesInstalled = label != null && !label.equals("Market");
        }
        catch (PackageManager.NameNotFoundException e) {
            playServicesInstalled = false;
        }
        return playServicesInstalled;
    }
}

