/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore.interaction;

import com.stonecraft.datastore.interaction.Join;
import java.util.ArrayList;
import java.util.List;

public class Query
implements Cloneable {
    private Boolean myIsdistinct;
    private String[] myColumns;
    private String myWhereClause;
    private List<String> myArguments;
    private String myGroupBy;
    private String myHaving;
    private String myOrderBy;
    private int myLimit;
    private int myOffset;
    private String myTable;
    private List<Join> myJoins;

    public Query(String tableName) {
        this.myTable = tableName;
        this.myArguments = new ArrayList<String>();
        this.myJoins = new ArrayList<Join>();
    }

    public Query(Query query) {
        this.myIsdistinct = query.myIsdistinct;
        this.myColumns = query.myColumns;
        this.myWhereClause = query.myWhereClause;
        this.myArguments = new ArrayList<String>(query.myArguments);
        this.myGroupBy = query.myGroupBy;
        this.myHaving = query.myHaving;
        this.myOrderBy = query.myOrderBy;
        this.myLimit = query.myLimit;
        this.myOffset = query.myOffset;
        this.myTable = query.myTable;
        this.myJoins = new ArrayList<Join>(query.myJoins.size());
        for (Join join : query.myJoins) {
            this.myJoins.add(new Join(join));
        }
    }

    public String getTable() {
        return this.myTable;
    }

    public List<Join> getJoins() {
        return this.myJoins;
    }

    public Query addJoins(Join join) {
        this.myJoins.add(join);
        return this;
    }

    public boolean isdistinct() {
        if (this.myIsdistinct == null) {
            return false;
        }
        return this.myIsdistinct;
    }

    public String[] getColumns() {
        return this.myColumns;
    }

    public String getWhereClause() {
        return this.myWhereClause;
    }

    public List<String> getSelectionArgs() {
        return this.myArguments;
    }

    public String getGroupBy() {
        return this.myGroupBy;
    }

    public String getHaving() {
        return this.myHaving;
    }

    public String getOrderBy() {
        return this.myOrderBy;
    }

    public int getLimit() {
        return this.myLimit;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public Query distinct(boolean isDistinct) {
        this.myIsdistinct = isDistinct;
        return this;
    }

    public Query columns(String[] columns) {
        this.myColumns = columns;
        return this;
    }

    public Query whereClause(String where) {
        this.myWhereClause = where;
        return this;
    }

    public Query addArgument(String arg) {
        this.myArguments.add(arg);
        return this;
    }

    public Query groupBy(String groupBy) {
        this.myGroupBy = groupBy;
        return this;
    }

    public Query having(String having) {
        this.myHaving = having;
        return this;
    }

    public Query orderBy(String orderBy) {
        this.myOrderBy = orderBy;
        return this;
    }

    public Query limit(int limit) {
        this.myLimit = limit;
        return this;
    }

    public Query offset(int offset) {
        this.myOffset = offset;
        return this;
    }
}

