/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import android.os.AsyncTask;
import com.stonecraft.datastore.Datastore;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interfaces.OnTaskCompleteListener;
import com.stonecraft.datastore.interfaces.Tasker;
import java.util.ArrayList;
import java.util.List;

abstract class DatabaseTask
extends AsyncTask<Void, Void, DatabaseException>
implements Tasker {
    protected int myToken;
    protected Datastore myDatastore;
    private int myTaskId;
    private List<OnTaskCompleteListener> myTaskListeners;

    public DatabaseTask(int taskId, int token, Datastore datastore) {
        this.myTaskId = taskId;
        this.myToken = token;
        this.myDatastore = datastore;
        this.myTaskListeners = new ArrayList<OnTaskCompleteListener>();
    }

    public int getTaskId() {
        return this.myTaskId;
    }

    @Override
    public int getToken() {
        return this.myToken;
    }

    @Override
    public void addOnTaskCompleteListener(OnTaskCompleteListener listener) {
        if (listener != null) {
            this.myTaskListeners.add(listener);
        }
    }

    @Override
    public void removeOnTaskCompleteListener(OnTaskCompleteListener listener) {
        this.myTaskListeners.remove(listener);
    }

    @Override
    public void notifyTaskListeners() {
        for (OnTaskCompleteListener listener : this.myTaskListeners) {
            listener.onTaskComplete(this);
        }
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    protected void onPostExecute(DatabaseException e) {
        this.notifyStmtListeners(e);
        this.notifyTaskListeners();
    }

    protected DatabaseException doInBackground(Void ... params) {
        try {
            this.startTask();
            return null;
        }
        catch (DatabaseException e) {
            return e;
        }
    }

    public abstract void startTask() throws DatabaseException;

    @Override
    public boolean isTaskRunning() {
        return this.getStatus() == AsyncTask.Status.RUNNING;
    }

    abstract void notifyStmtListeners(DatabaseException var1);
}

