/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import com.stonecraft.datastore.DatabaseUtils;
import com.stonecraft.datastore.DbSchemaModel;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Join;
import com.stonecraft.datastore.interaction.Query;
import com.stonecraft.datastore.utils.StringUtils;
import com.stonecraft.datastore.view.DatabaseTable;
import java.util.Map;

public class AndroidQueryCreator {
    private static final String JOIN_CROSS_STRING = " CROSS JOIN ";
    private static final String JOIN_INNER_STRING = " INNER JOIN ";
    private static final String JOIN_LEFT_OUTER_STRING = " LEFT OUTER JOIN ";
    private DbSchemaModel myDbSchema;

    public AndroidQueryCreator(DbSchemaModel schemaModel) {
        this.myDbSchema = schemaModel;
    }

    public String getSQLJoinQuery(Query query) throws DatabaseException {
        StringBuilder statementBuilder = new StringBuilder();
        statementBuilder.append("SELECT");
        StringBuilder colBuilder = new StringBuilder();
        if (query.getColumns() == null || query.getColumns().length == 0) {
            colBuilder.append(this.getColumnClause(query));
        } else {
            for (String column : query.getColumns()) {
                if (colBuilder.length() > 0) {
                    colBuilder.append(",");
                }
                colBuilder.append(this.getColumnClause(column));
            }
        }
        if (query.isdistinct()) {
            statementBuilder.append(" DISTINCT").append("(");
            statementBuilder.append((CharSequence)colBuilder).append(") ");
        } else {
            statementBuilder.append(" " + colBuilder + " ");
        }
        statementBuilder.append("FROM").append(this.getJoinClause(query.getTable(), query));
        if (!StringUtils.isEmpty(query.getWhereClause())) {
            statementBuilder.append(" WHERE " + query.getWhereClause());
        }
        if (!StringUtils.isEmpty(query.getOrderBy())) {
            statementBuilder.append(" ORDER BY " + query.getOrderBy());
        }
        if (!StringUtils.isEmpty(query.getGroupBy())) {
            statementBuilder.append(" GROUP BY " + query.getGroupBy());
        }
        if (!StringUtils.isEmpty(query.getHaving())) {
            statementBuilder.append(" HAVING " + query.getHaving());
        }
        if (query.getLimit() > 0) {
            statementBuilder.append(" LIMIT " + query.getLimit());
        }
        if (query.getLimit() > 0 && query.getOffset() > 0) {
            statementBuilder.append(" OFFSET " + query.getOffset());
        }
        return statementBuilder.toString();
    }

    public String getColumnClause(Query query) {
        StringBuilder columnClause = new StringBuilder();
        String[] columns = query.getColumns();
        if (columns != null && columns.length > 0) {
            return this.getColumnClause(query.getTable(), columns);
        }
        String mainTable = this.getColumnClause(query.getTable(), null);
        if (!query.getJoins().isEmpty()) {
            for (Join join : query.getJoins()) {
                columnClause.append(", ");
                columnClause.append(this.getColumnClause(join.getTable(), null));
            }
        }
        return mainTable + " " + columnClause.toString();
    }

    public String getColumnClause(String delimitedTableColumnName) throws DatabaseException {
        String[] tableColumnPair = delimitedTableColumnName.split("\\.");
        int count = tableColumnPair.length;
        try {
            return delimitedTableColumnName + " AS " + DatabaseUtils.getDatabaseAsName(tableColumnPair[0], tableColumnPair[1]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DatabaseException("Column names must be delimited with the table name in a joined query");
        }
    }

    public String getColumnClause(String tableName, String[] columns) {
        DatabaseTable table = this.myDbSchema.getTable(tableName);
        StringBuilder columnClause = new StringBuilder();
        if (columns != null && columns.length > 0) {
            for (String column : columns) {
                columnClause.append((String)column + " AS " + (String)column);
            }
        }
        for (Map.Entry entry : table.getColumns().entrySet()) {
            if (columnClause.length() > 0) {
                columnClause.append(", ");
            }
            String key = tableName + "." + (String)entry.getKey();
            columnClause.append(key + " AS " + DatabaseUtils.getDatabaseAsName(tableName, (String)entry.getKey()));
        }
        return columnClause.toString();
    }

    private String getJoinClause(String table, Query statement) {
        StringBuilder joinBuilder = new StringBuilder(" ");
        joinBuilder.append(table);
        for (Join join : statement.getJoins()) {
            switch (join.getJoinType()) {
                case 0: {
                    joinBuilder.append(JOIN_CROSS_STRING);
                    break;
                }
                case 1: {
                    joinBuilder.append(JOIN_INNER_STRING);
                    break;
                }
                case 2: {
                    joinBuilder.append(JOIN_LEFT_OUTER_STRING);
                }
            }
            joinBuilder.append(join.getTable());
            if (join.getJoinType() == 0) continue;
            joinBuilder.append(" ").append("ON").append(" ");
            StringBuilder joinExpressionBuilder = new StringBuilder();
            for (Join.JoinExpression expression : join.getJoinExpressions()) {
                if (joinExpressionBuilder.length() > 0) {
                    joinExpressionBuilder.append(" ").append("AND").append(" ");
                }
                joinExpressionBuilder.append((String)expression.getLeftColumn().first).append(".");
                joinExpressionBuilder.append((String)expression.getLeftColumn().second);
                joinExpressionBuilder.append(" = ");
                joinExpressionBuilder.append((String)expression.getRightColumn().first).append(".");
                joinExpressionBuilder.append((String)expression.getRightColumn().second);
            }
            joinBuilder.append((CharSequence)joinExpressionBuilder);
        }
        return joinBuilder.toString();
    }
}

