/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.Loader;
import android.support.v4.os.CancellationSignal;
import android.support.v4.os.OperationCanceledException;
import android.text.TextUtils;
import com.stonecraft.datastore.Datastore;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Query;
import java.util.Calendar;

public class DbDataLoader<T>
extends AsyncTaskLoader<T> {
    private volatile CancellationSignal myCancellationSignal;
    private final Loader.ForceLoadContentObserver myObserver = new Loader.ForceLoadContentObserver((Loader)this);
    private T myResult;
    private final String myDbName;
    private Uri myAlternateWatchUri;
    private final Query myQuery;
    private final Class myLoaderResultType;
    private Calendar myTableUpdateTime;

    public DbDataLoader(Context context, String dbName, Query query, Class loaderResultType) {
        super(context);
        this.myDbName = dbName;
        this.myQuery = query;
        this.myLoaderResultType = loaderResultType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T loadInBackground() {
        DbDataLoader dbDataLoader = this;
        synchronized (dbDataLoader) {
            if (this.isLoadInBackgroundCanceled()) {
                throw new OperationCanceledException();
            }
            this.myCancellationSignal = new CancellationSignal();
        }
        Datastore ds = Datastore.getDataStore(this.myDbName);
        T[] result = null;
        try {
            result = ds.executeQuery(this.myQuery, this.myLoaderResultType);
        }
        catch (DatabaseException e) {
            throw new RuntimeException("An error occured in the loader while trying to get data from the database", e);
        }
        catch (ClassCastException e) {
            throw new ClassCastException("The class type passed into the loader does not match the generic type of the loader. [" + e + "]");
        }
        this.myCancellationSignal = null;
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelLoadInBackground() {
        super.cancelLoadInBackground();
        DbDataLoader dbDataLoader = this;
        synchronized (dbDataLoader) {
            if (this.myCancellationSignal != null) {
                this.myCancellationSignal.cancel();
            }
        }
    }

    public void deliverResult(T result) {
        if (this.isReset()) {
            this.myResult = null;
            return;
        }
        this.myResult = result;
        if (this.isStarted()) {
            super.deliverResult(result);
        }
    }

    public void ignoreUpdates() {
        this.getContext().getContentResolver().unregisterContentObserver((ContentObserver)this.myObserver);
    }

    public void receiveUpdates() {
        Uri tableUri = this.getWatchUri();
        if (this.isStarted() && tableUri != null && !TextUtils.isEmpty((CharSequence)tableUri.toString())) {
            this.getContext().getContentResolver().registerContentObserver(this.getWatchUri(), false, (ContentObserver)this.myObserver);
        }
    }

    public void setAlternateWatchUri(Uri uri) {
        this.myAlternateWatchUri = uri;
    }

    protected void onStartLoading() {
        Uri tableUri = this.getWatchUri();
        if (tableUri != null && !TextUtils.isEmpty((CharSequence)tableUri.toString())) {
            this.getContext().getContentResolver().registerContentObserver(tableUri, false, (ContentObserver)this.myObserver);
        }
        Datastore ds = Datastore.getDataStore(this.myDbName);
        Calendar tableUpdateTime = ds.getLastTableUpdateTime(this.myQuery.getTable());
        if (this.takeContentChanged() || this.myResult == null || tableUpdateTime != this.myTableUpdateTime || this.myResult != null && tableUpdateTime != null && tableUpdateTime.compareTo(this.myTableUpdateTime) > 0) {
            this.myTableUpdateTime = tableUpdateTime;
            this.forceLoad();
            return;
        }
        if (this.myResult != null) {
            this.deliverResult(this.myResult);
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
        this.getContext().getContentResolver().unregisterContentObserver((ContentObserver)this.myObserver);
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
    }

    private Uri getWatchUri() {
        if (this.myAlternateWatchUri != null) {
            return this.myAlternateWatchUri;
        }
        Datastore ds = Datastore.getDataStore(this.myDbName);
        return ds.getTableUri(this.myQuery.getTable());
    }
}

