/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore.parser;

import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.stonecraft.datastore.DatabaseUtils;
import com.stonecraft.datastore.DbSchemaModel;
import com.stonecraft.datastore.exceptions.SchemaParseException;
import com.stonecraft.datastore.utils.StringUtils;
import com.stonecraft.datastore.view.DatabaseColumn;
import com.stonecraft.datastore.view.DatabaseTable;
import com.stonecraft.datastore.view.SQLiteColumn;
import com.stonecraft.datastore.view.SQLiteTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DatabaseParser
extends AsyncTask<InputStream, Void, DbSchemaModel> {
    private static final String SCHEMA = "Schema";
    private static final String NAME = "Name";
    private static final String VERSION = "Version";
    private static final String TABLE = "Table";
    private static final String COLUMN = "Column";
    private static final String TYPE = "Type";
    private static final String PRIMARY = "Primary";
    private static final String AUTOINCREMENT = "AutoIncrement";
    private static final String NULLABLE = "Nullable";
    private static final String LENGTH = "length";
    private static final String URI = "uri";
    private static final String DEFAULT = "Default";
    private DbSchemaModel mySchema;
    private OnSchemaModelCreated myOnSchemaModelCreated;
    private DefaultHandler myHandler = new DefaultHandler(){
        private String myCurrentElement;
        private StringBuilder myTagTextBuilder;
        private String myCurrentBlock;
        private Map<String, String> myTableValues;
        private Map<String, String> myColumnValues;
        private List<DatabaseColumn> myCols = new ArrayList<DatabaseColumn>();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.myCurrentElement = qName;
            this.myTagTextBuilder = new StringBuilder();
            if (this.myCurrentElement.equalsIgnoreCase(DatabaseParser.SCHEMA)) {
                this.myCurrentBlock = qName;
            } else if (this.myCurrentElement.equalsIgnoreCase(DatabaseParser.TABLE)) {
                this.myCurrentBlock = qName;
            } else if (this.myCurrentElement.equalsIgnoreCase(DatabaseParser.COLUMN)) {
                this.myCurrentBlock = qName;
            }
            if (this.myCurrentBlock.equalsIgnoreCase(DatabaseParser.TABLE)) {
                if (this.myTableValues == null || this.myCols == null) {
                    this.myTableValues = new HashMap<String, String>();
                    this.myCols = new ArrayList<DatabaseColumn>();
                }
                if (DatabaseParser.TABLE.equalsIgnoreCase(qName)) {
                    this.myTableValues.put(DatabaseParser.URI, attributes.getValue(DatabaseParser.URI));
                }
            } else if (this.myCurrentBlock.equalsIgnoreCase(DatabaseParser.COLUMN)) {
                if (this.myColumnValues == null) {
                    this.myColumnValues = new HashMap<String, String>();
                }
                if (this.myCurrentElement.equalsIgnoreCase(DatabaseParser.TYPE)) {
                    this.myColumnValues.put(DatabaseParser.LENGTH, attributes.getValue(DatabaseParser.LENGTH));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String tagTextValue = this.myTagTextBuilder.toString().replace("(\\r|\\n|\\t)", "");
            if (tagTextValue.equals("CONTACTS")) {
                String breakHere = "";
            }
            if (this.myCurrentBlock.equalsIgnoreCase(DatabaseParser.SCHEMA)) {
                if (this.myCurrentElement.equalsIgnoreCase(DatabaseParser.NAME)) {
                    DatabaseParser.this.mySchema.setName(tagTextValue);
                } else if (this.myCurrentElement.equalsIgnoreCase(DatabaseParser.VERSION)) {
                    DatabaseParser.this.mySchema.setVersion(Integer.parseInt(tagTextValue));
                }
            } else if (this.myCurrentBlock.equalsIgnoreCase(DatabaseParser.TABLE) && !this.myCurrentBlock.equalsIgnoreCase(this.myCurrentElement)) {
                this.myTableValues.put(this.myCurrentElement, tagTextValue);
            } else if (this.myCurrentBlock.equalsIgnoreCase(DatabaseParser.COLUMN) && !this.myCurrentBlock.equalsIgnoreCase(this.myCurrentElement) && !TextUtils.isEmpty((CharSequence)this.myCurrentElement)) {
                this.myColumnValues.put(this.myCurrentElement, tagTextValue);
            }
            this.myCurrentElement = "";
            if (qName.equalsIgnoreCase(DatabaseParser.TABLE)) {
                if (TextUtils.isEmpty((CharSequence)this.myTableValues.get(DatabaseParser.URI))) {
                    throw new SchemaParseException("There was no uri attribute in the table element " + this.myTableValues.get(DatabaseParser.NAME));
                }
                DatabaseParser.this.mySchema.addTable(this.buildTable());
                this.myTableValues = new HashMap<String, String>();
                this.myCols = new ArrayList<DatabaseColumn>();
            } else if (qName.equalsIgnoreCase(DatabaseParser.COLUMN)) {
                this.myCols.add(this.buildCol());
                this.myColumnValues = new HashMap<String, String>();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!TextUtils.isEmpty((CharSequence)this.myCurrentElement)) {
                this.myTagTextBuilder.append(new String(ch, start, start + length));
            }
        }

        private DatabaseTable buildTable() {
            try {
                String name = this.myTableValues.get(DatabaseParser.NAME);
                String uri = this.myTableValues.get(DatabaseParser.URI);
                SQLiteTable table = new SQLiteTable(name, Uri.parse((String)uri));
                for (DatabaseColumn col : this.myCols) {
                    table.addColumn(col);
                }
                return table;
            }
            catch (Exception e) {
                System.out.println("Failed to create Table " + e);
                return null;
            }
        }

        private DatabaseColumn buildCol() {
            SQLiteColumn dbColumn = null;
            String name = this.myColumnValues.get(DatabaseParser.NAME);
            int type = DatabaseUtils.getIntDatatype(StringUtils.getStringNotNull(this.myColumnValues.get(DatabaseParser.TYPE)));
            String lengthString = StringUtils.getStringNotNull(this.myColumnValues.get(DatabaseParser.LENGTH));
            int length = 0;
            if (TextUtils.isDigitsOnly((CharSequence)lengthString)) {
                length = Integer.parseInt(lengthString);
            }
            boolean primary = StringUtils.getStringNotNull(this.myColumnValues.get(DatabaseParser.PRIMARY)).equalsIgnoreCase(Boolean.TRUE.toString());
            boolean autoIncrement = StringUtils.getStringNotNull(this.myColumnValues.get(DatabaseParser.AUTOINCREMENT)).equalsIgnoreCase(Boolean.TRUE.toString());
            boolean nullable = StringUtils.getStringNotNull(this.myColumnValues.get(DatabaseParser.NULLABLE)).equalsIgnoreCase(Boolean.TRUE.toString());
            String defaultValue = this.myColumnValues.get(DatabaseParser.DEFAULT);
            dbColumn = new SQLiteColumn(name, type, length, primary, nullable, autoIncrement);
            if (!TextUtils.isEmpty((CharSequence)defaultValue)) {
                dbColumn.setDefaultValue(defaultValue);
            }
            return dbColumn;
        }
    };

    public DatabaseParser(OnSchemaModelCreated listener) {
        this.mySchema = new DbSchemaModel();
        this.myOnSchemaModelCreated = listener;
    }

    protected DbSchemaModel doInBackground(InputStream ... params) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(params[0], this.myHandler);
        }
        catch (MalformedURLException e) {
            System.out.println("MalformedURLException " + e);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("IOException " + e);
            e.printStackTrace();
        }
        catch (SAXException e) {
            System.out.println("SAXException " + e);
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            System.out.println("ParserConfigurationException " + e);
            e.printStackTrace();
        }
        this.myOnSchemaModelCreated.OnSchemaModelCreated(this.mySchema);
        return this.mySchema;
    }

    public DbSchemaModel parse(String databaseLocation) {
        try {
            FileInputStream is = new FileInputStream(new File(databaseLocation));
            this.execute(new InputStream[]{is});
        }
        catch (IOException e) {
            System.out.println("IOException " + e);
            e.printStackTrace();
        }
        return this.mySchema;
    }

    public static interface OnSchemaModelCreated {
        public void OnSchemaModelCreated(DbSchemaModel var1);
    }
}

