/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore.view;

import android.net.Uri;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.utils.StringUtils;
import com.stonecraft.datastore.view.DatabaseColumn;
import com.stonecraft.datastore.view.DatabaseTable;

public class SQLiteTable
extends DatabaseTable {
    public SQLiteTable(String name, Uri uri) {
        super(name, uri);
    }

    @Override
    public String getCreateTableStmt() throws DatabaseException {
        boolean hasCompositeKey = this.hasCompositeKey();
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE").append(" ");
        builder.append(this.getDBName()).append("(");
        StringBuilder columnsString = new StringBuilder();
        for (DatabaseColumn col : this.myColumns.values()) {
            columnsString.append(col.getCreateColumnStmt(hasCompositeKey)).append(",");
        }
        builder.append(StringUtils.removeStringSuffix(columnsString.toString(), ","));
        if (hasCompositeKey) {
            builder.append(",").append(this.getPrimaryKeyString());
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public boolean hasCompositeKey() {
        int primaryKeyCount = 0;
        for (DatabaseColumn col : this.myColumns.values()) {
            if (!col.isPrimarykey()) continue;
            ++primaryKeyCount;
        }
        return primaryKeyCount > 1;
    }

    private String getPrimaryKeyString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PRIMARY KEY").append("(");
        StringBuilder columns = new StringBuilder();
        for (DatabaseColumn col : this.myColumns.values()) {
            if (!col.isPrimarykey()) continue;
            columns.append(col.getName()).append(",");
        }
        builder.append(StringUtils.removeStringSuffix(columns.toString(), ",")).append(")");
        return builder.toString();
    }
}

