/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore.view;

import android.text.TextUtils;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.utils.StringUtils;
import com.stonecraft.datastore.view.DatabaseColumn;

public class SQLiteColumn
extends DatabaseColumn {
    public static final String DATATYPE_NULL = "NULL";
    public static final String DATATYPE_INTEGER = "INTEGER";
    public static final String DATATYPE_REAL = "REAL";
    public static final String DATATYPE_TEXT = "TEXT";
    public static final String DATATYPE_BLOB = "BLOB";

    public SQLiteColumn(String name, int type, int length) {
        super(name, type, length, false);
    }

    public SQLiteColumn(String name, int type, int length, boolean isPrimaryKey) {
        super(name, type, length, isPrimaryKey, false);
    }

    public SQLiteColumn(String name, int type, int length, boolean isPrimaryKey, boolean isNullable) {
        super(name, type, length, isPrimaryKey, isNullable, false);
    }

    public SQLiteColumn(String name, int type, int length, boolean isPrimaryKey, boolean isNullable, boolean isAutoIncrement) {
        super(name, type, length, isPrimaryKey, isNullable, isAutoIncrement);
    }

    @Override
    public String getCreateColumnStmt(boolean hasTableCompositeKey) throws DatabaseException {
        StringBuilder builder = new StringBuilder();
        String type = this.getTypeString();
        builder.append(this.getName()).append(" ").append(type).append(" ");
        if (!this.isPrimarykey()) {
            if (!this.isNullable()) {
                builder.append("NOT NULL").append(" ");
            }
            if (!TextUtils.isEmpty((CharSequence)this.getDefaultValue())) {
                builder.append("DEFAULT").append(" ");
                if (type.equals(DATATYPE_TEXT)) {
                    builder.append("'").append(this.getDefaultValue()).append("'");
                } else {
                    builder.append(this.getDefaultValue());
                }
                builder.append(" ");
            }
        }
        if (!hasTableCompositeKey && this.isPrimarykey()) {
            builder.append("PRIMARY KEY").append(" ");
            if (this.isAutoIncrement()) {
                builder.append("AUTOINCREMENT");
            }
        }
        return StringUtils.removeStringSuffix(builder.toString(), " ");
    }

    @Override
    public boolean equals(Object o) {
        DatabaseColumn compareCol = (DatabaseColumn)o;
        return this.getName().equals(compareCol.getName()) && this.getType() == compareCol.getType() && this.isAutoIncrement() == compareCol.isAutoIncrement() && this.isNullable() == compareCol.isNullable() && this.isPrimarykey() == compareCol.isPrimarykey();
    }

    @Override
    protected String getTypeString() throws DatabaseException {
        switch (this.getType()) {
            case 0: {
                return DATATYPE_NULL;
            }
            case 4: 
            case 16: 
            case 91: {
                return DATATYPE_INTEGER;
            }
            case 8: {
                return DATATYPE_REAL;
            }
            case 12: {
                return DATATYPE_TEXT;
            }
            case 2004: {
                return DATATYPE_BLOB;
            }
        }
        throw new DatabaseException("The data type is unknown for column " + this.getName());
    }
}

