/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.stonecraft.datastore.DatabaseUtils;
import com.stonecraft.datastore.DbColumnName;
import com.stonecraft.datastore.DbJoin;
import com.stonecraft.datastore.DbTableName;
import com.stonecraft.datastore.RSData;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Query;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

abstract class ObjectInjector {
    private Query myQuery;
    private Map<Class, Field[]> myClassFields;
    protected Map<Field, Annotation> myAnnotations;
    private Map<Field, Class> myListTypeClass;

    public ObjectInjector(Query query) {
        this.myQuery = query;
        this.myClassFields = new HashMap<Class, Field[]>();
        this.myAnnotations = new HashMap<Field, Annotation>();
        this.myListTypeClass = new HashMap<Field, Class>();
    }

    protected Class getTypeOfList(Field field) {
        if (this.myListTypeClass.containsKey(field)) {
            return this.myListTypeClass.get(field);
        }
        ParameterizedType stringListType = (ParameterizedType)field.getGenericType();
        Class klass = (Class)stringListType.getActualTypeArguments()[0];
        this.myListTypeClass.put(field, klass);
        return klass;
    }

    protected Annotation getAnnotation(Field field) {
        Annotation[] annotations;
        if (this.myAnnotations.containsKey(field)) {
            return this.myAnnotations.get(field);
        }
        for (Annotation annotation : annotations = field.getAnnotations()) {
            if (!(annotation instanceof DbJoin) && !(annotation instanceof DbTableName) && !(annotation instanceof DbColumnName)) continue;
            this.myAnnotations.put(field, annotation);
            return annotation;
        }
        return null;
    }

    protected Field[] getFields(Class klass) {
        Field[] fields = null;
        if (this.myClassFields.containsKey(klass)) {
            fields = this.myClassFields.get(klass);
        } else {
            fields = klass.getDeclaredFields();
            this.myClassFields.put(klass, fields);
        }
        return fields;
    }

    protected String getColumnKey(String table, String column) {
        String columnKey = null;
        columnKey = column.contains(DatabaseUtils.getTableColumnSeparator()) ? DatabaseUtils.normaliseTableColumnAsName(column) : (!this.myQuery.getJoins().isEmpty() && TextUtils.isEmpty((CharSequence)table) ? DatabaseUtils.getDatabaseAsName(this.myQuery.getTable(), column) : (!TextUtils.isEmpty((CharSequence)table) ? DatabaseUtils.getDatabaseAsName(table, column) : column));
        return columnKey;
    }

    protected <T> void injectValue(RSData data, T rowClass, Field field, String column) throws IllegalAccessException, DatabaseException {
        field.setAccessible(true);
        Class<?> fieldType = field.getType();
        if (data.hasColumn(column) && !data.containsNull(column)) {
            if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                field.set(rowClass, data.getIntValue(column));
            } else if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                field.set(rowClass, data.getBooleanValue(column));
            } else if (fieldType == Double.TYPE || fieldType == Double.class) {
                field.set(rowClass, data.getDoubleValue(column));
            } else if (fieldType == Float.TYPE || fieldType == Float.class) {
                field.set(rowClass, Float.valueOf(data.getFloatValue(column)));
            } else if (fieldType == String.class) {
                field.set(rowClass, data.getStringValue(column));
            } else if (fieldType == Calendar.class) {
                field.set(rowClass, data.getCalendarValue(column));
            } else if (fieldType == Date.class) {
                field.set(rowClass, data.getDateValue(column));
            } else if (fieldType == Byte[].class) {
                field.set(rowClass, data.getBlobData(column));
            } else if (fieldType == Bitmap.class) {
                byte[] bmpData = data.getBlobData(column);
                Bitmap bmp = BitmapFactory.decodeByteArray((byte[])bmpData, (int)0, (int)bmpData.length);
                field.set(rowClass, bmp);
            }
        }
    }

    public abstract <T> T[] inject(RSData var1, Class<T> var2) throws DatabaseException;
}

