/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore.interaction;

import com.stonecraft.datastore.interaction.Join;
import java.util.ArrayList;
import java.util.List;

public class Query {
    private Boolean myIsdistinct;
    private String[] myColumns;
    private String myWhereClause;
    private List<String> myArguments;
    private String myGroupBy;
    private String myHaving;
    private String myOrderBy;
    private String myLimit;
    private String myTable;
    private List<Join> myJoins;

    public Query(String tableName) {
        this.myTable = tableName;
        this.myArguments = new ArrayList<String>();
        this.myJoins = new ArrayList<Join>();
    }

    public String getTable() {
        return this.myTable;
    }

    public List<Join> getJoins() {
        return this.myJoins;
    }

    public void addJoins(Join join) {
        this.myJoins.add(join);
    }

    public boolean isdistinct() {
        if (this.myIsdistinct == null) {
            return false;
        }
        return this.myIsdistinct;
    }

    public String[] getColumns() {
        return this.myColumns;
    }

    public String getWhereClause() {
        return this.myWhereClause;
    }

    public List<String> getSelectionArgs() {
        return this.myArguments;
    }

    public String getGroupBy() {
        return this.myGroupBy;
    }

    public String getHaving() {
        return this.myHaving;
    }

    public String getOrderBy() {
        return this.myOrderBy;
    }

    public String getLimit() {
        return this.myLimit;
    }

    public Query distinct(boolean isDistinct) {
        this.myIsdistinct = isDistinct;
        return this;
    }

    public Query columns(String[] columns) {
        this.myColumns = columns;
        return this;
    }

    public Query whereClause(String where) {
        this.myWhereClause = where;
        return this;
    }

    public Query addArgument(String arg) {
        this.myArguments.add(arg);
        return this;
    }

    public Query groupBy(String groupBy) {
        this.myGroupBy = groupBy;
        return this;
    }

    public Query having(String having) {
        this.myHaving = having;
        return this;
    }

    public Query orderBy(String orderBy) {
        this.myOrderBy = orderBy;
        return this;
    }

    public Query limit(String limit) {
        this.myLimit = limit;
        return this;
    }
}

