/*
 * Decompiled with CFR 0.152.
 */
package com.stonecraft.datastore;

import com.stonecraft.datastore.DatabaseObjectInjector;
import com.stonecraft.datastore.DatabaseTask;
import com.stonecraft.datastore.RSData;
import com.stonecraft.datastore.exceptions.DatabaseException;
import com.stonecraft.datastore.interaction.Query;
import com.stonecraft.datastore.interaction.RawSQLQuery;
import com.stonecraft.datastore.interaction.Statement;
import com.stonecraft.datastore.interfaces.IDBConnector;
import com.stonecraft.datastore.interfaces.OnQueryComplete;

class DatabaseQueryTask
extends DatabaseTask {
    private Statement myQuery;
    private OnQueryComplete myQueryListener;
    private Class myInjectorClass;

    public DatabaseQueryTask(int taskId, int token, IDBConnector conn, Statement query) {
        super(taskId, token, conn);
        this.myQuery = query;
    }

    public void setInjectorClass(Class injectorClass) {
        this.myInjectorClass = injectorClass;
    }

    @Override
    public void executeTask() {
        try {
            T[] result = this.executeTask(this.myInjectorClass);
            this.myQueryListener.onQueryComplete(this.myToken, result);
        }
        catch (DatabaseException e) {
            this.myQueryListener.onQueryFailed(this.myToken, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] executeTask(Class<T> classOfT) throws DatabaseException {
        RSData data = null;
        try {
            if (this.myQuery instanceof Query) {
                data = this.myConnection.query((Query)this.myQuery);
                Object[] objectArray = (Object[])this.parseQuery(data, classOfT);
                return objectArray;
            }
            if (this.myQuery instanceof RawSQLQuery) {
                data = this.myConnection.executeRawQuery(((RawSQLQuery)this.myQuery).getQuery());
                Object[] objectArray = (Object[])this.parseQuery(data, classOfT);
                return objectArray;
            }
            try {
                throw new DatabaseException("Unknown statement type " + this.myQuery.getClass().getSimpleName() + ". Must be either " + Query.class.getSimpleName() + " or " + RawSQLQuery.class.getSimpleName());
            }
            catch (DatabaseException e) {
                if (data != null) {
                    data.close();
                }
                this.myQueryListener.onQueryFailed(this.myToken, e);
            }
        }
        finally {
            this.notifyTaskListeners();
        }
        return null;
    }

    private Object parseQuery(RSData data, Class classOfT) throws DatabaseException {
        if (classOfT.getName().equals(RSData.class.getName())) {
            return new RSData[]{data};
        }
        T[] result = null;
        if (this.myQueryListener != null) {
            result = this.myQueryListener.parseData(data);
        }
        if (result == null) {
            return new DatabaseObjectInjector().inject(data, classOfT);
        }
        data.close();
        return result;
    }

    public void setOnQueryCompleteListener(OnQueryComplete listener) {
        this.myQueryListener = listener;
    }
}

