/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.imageviewer.viewer.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.app.AlertDialog;
import com.stfalcon.imageviewer.R;
import com.stfalcon.imageviewer.listeners.OnDismissListener;
import com.stfalcon.imageviewer.listeners.OnImageChangeListener;
import com.stfalcon.imageviewer.viewer.builder.BuilderData;
import com.stfalcon.imageviewer.viewer.view.ImageViewerView;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\rJ\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0002J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\tJ\u0014\u0010\u001c\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eJ\u0010\u0010\u001f\u001a\u00020\u00132\b\u0010 \u001a\u0004\u0018\u00010!R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/stfalcon/imageviewer/viewer/dialog/ImageViewerDialog;", "T", "", "context", "Landroid/content/Context;", "builderData", "Lcom/stfalcon/imageviewer/viewer/builder/BuilderData;", "(Landroid/content/Context;Lcom/stfalcon/imageviewer/viewer/builder/BuilderData;)V", "animateOpen", "", "dialog", "Landroidx/appcompat/app/AlertDialog;", "dialogStyle", "", "getDialogStyle", "()I", "viewerView", "Lcom/stfalcon/imageviewer/viewer/view/ImageViewerView;", "close", "", "getCurrentPosition", "onDialogKeyEvent", "keyCode", "event", "Landroid/view/KeyEvent;", "setupViewerView", "show", "animate", "updateImages", "images", "", "updateTransitionImage", "imageView", "Landroid/widget/ImageView;", "imageviewer_release"})
public final class ImageViewerDialog<T> {
    private final AlertDialog dialog;
    private final ImageViewerView<T> viewerView;
    private boolean animateOpen;
    private final BuilderData<T> builderData;

    private final int getDialogStyle() {
        return this.builderData.getShouldStatusBarHide() ? R.style.ImageViewerDialog_NoStatusBar : R.style.ImageViewerDialog_Default;
    }

    public final void show(boolean animate) {
        this.animateOpen = animate;
        this.dialog.show();
    }

    public final void close() {
        this.viewerView.close$imageviewer_release();
    }

    public final void updateImages(@NotNull List<? extends T> images) {
        Intrinsics.checkParameterIsNotNull(images, (String)"images");
        this.viewerView.updateImages$imageviewer_release(images);
    }

    public final int getCurrentPosition() {
        return this.viewerView.getCurrentPosition$imageviewer_release();
    }

    public final void updateTransitionImage(@Nullable ImageView imageView) {
        this.viewerView.updateTransitionImage$imageviewer_release(imageView);
    }

    private final boolean onDialogKeyEvent(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 1 && !event.isCanceled()) {
            if (this.viewerView.isScaled$imageviewer_release()) {
                this.viewerView.resetScale$imageviewer_release();
            } else {
                this.viewerView.close$imageviewer_release();
            }
        }
        return true;
    }

    private final void setupViewerView() {
        ImageViewerView<T> imageViewerView;
        ImageViewerView<T> $receiver = imageViewerView = this.viewerView;
        $receiver.setZoomingAllowed$imageviewer_release(this.builderData.isZoomingAllowed());
        $receiver.setSwipeToDismissAllowed$imageviewer_release(this.builderData.isSwipeToDismissAllowed());
        $receiver.setContainerPadding$imageviewer_release(this.builderData.getContainerPaddingPixels());
        $receiver.setImagesMargin$imageviewer_release(this.builderData.getImageMarginPixels());
        $receiver.setOverlayView$imageviewer_release(this.builderData.getOverlayView());
        $receiver.setBackgroundColor(this.builderData.getBackgroundColor());
        $receiver.setImages$imageviewer_release(this.builderData.getImages(), this.builderData.getStartPosition(), this.builderData.getImageLoader());
        $receiver.setOnPageChange$imageviewer_release((Function1<Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ ImageViewerDialog this$0;
            {
                this.this$0 = imageViewerDialog;
                super(1);
            }

            public final void invoke(int position) {
                block0: {
                    OnImageChangeListener onImageChangeListener = ImageViewerDialog.access$getBuilderData$p(this.this$0).getImageChangeListener();
                    if (onImageChangeListener == null) break block0;
                    onImageChangeListener.onImageChange(position);
                }
            }
        }));
        $receiver.setOnDismiss$imageviewer_release((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ImageViewerDialog this$0;
            {
                this.this$0 = imageViewerDialog;
                super(0);
            }

            public final void invoke() {
                ImageViewerDialog.access$getDialog$p(this.this$0).dismiss();
            }
        }));
    }

    public ImageViewerDialog(@NotNull Context context, @NotNull BuilderData<T> builderData) {
        AlertDialog alertDialog;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(builderData, (String)"builderData");
        this.builderData = builderData;
        this.viewerView = new ImageViewerView(context, null, 0, 6, null);
        this.animateOpen = true;
        this.setupViewerView();
        AlertDialog alertDialog2 = new AlertDialog.Builder(context, this.getDialogStyle()).setView((View)this.viewerView).setOnKeyListener(new DialogInterface.OnKeyListener(){

            public final boolean onKey(DialogInterface $noName_0, int keyCode, KeyEvent event) {
                KeyEvent keyEvent = event;
                Intrinsics.checkExpressionValueIsNotNull((Object)keyEvent, (String)"event");
                return this.onDialogKeyEvent(keyCode, keyEvent);
            }
        }).create();
        ImageViewerDialog imageViewerDialog = this;
        AlertDialog $receiver = alertDialog2;
        $receiver.setOnShowListener(new DialogInterface.OnShowListener(this){
            final /* synthetic */ ImageViewerDialog this$0;
            {
                this.this$0 = imageViewerDialog;
            }

            public final void onShow(DialogInterface it) {
                ImageViewerDialog.access$getViewerView$p(this.this$0).open$imageviewer_release(ImageViewerDialog.access$getBuilderData$p(this.this$0).getTransitionView(), ImageViewerDialog.access$getAnimateOpen$p(this.this$0));
            }
        });
        $receiver.setOnDismissListener(new DialogInterface.OnDismissListener(this){
            final /* synthetic */ ImageViewerDialog this$0;
            {
                this.this$0 = imageViewerDialog;
            }

            public final void onDismiss(DialogInterface it) {
                block0: {
                    OnDismissListener onDismissListener = ImageViewerDialog.access$getBuilderData$p(this.this$0).getOnDismissListener();
                    if (onDismissListener == null) break block0;
                    onDismissListener.onDismiss();
                }
            }
        });
        AlertDialog alertDialog3 = alertDialog = alertDialog2;
        Intrinsics.checkExpressionValueIsNotNull((Object)alertDialog3, (String)"AlertDialog\n            \u2026Dismiss() }\n            }");
        imageViewerDialog.dialog = alertDialog3;
    }

    @NotNull
    public static final /* synthetic */ BuilderData access$getBuilderData$p(ImageViewerDialog $this) {
        return $this.builderData;
    }

    @NotNull
    public static final /* synthetic */ AlertDialog access$getDialog$p(ImageViewerDialog $this) {
        return $this.dialog;
    }

    @NotNull
    public static final /* synthetic */ ImageViewerView access$getViewerView$p(ImageViewerDialog $this) {
        return $this.viewerView;
    }

    public static final /* synthetic */ boolean access$getAnimateOpen$p(ImageViewerDialog $this) {
        return $this.animateOpen;
    }

    public static final /* synthetic */ void access$setAnimateOpen$p(ImageViewerDialog $this, boolean bl) {
        $this.animateOpen = bl;
    }
}

