/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.internal;

import java.io.File;
import java.util.Optional;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.logging.Logger;
import org.gradle.api.reporting.internal.CustomizableHtmlReportImpl;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.resources.TextResource;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.api.tasks.Input;

public abstract class SpotBugsHtmlReportImpl
extends CustomizableHtmlReportImpl {
    private static final long serialVersionUID = 6474874842199703745L;
    private final transient ResourceHandler handler;
    private final transient Configuration configuration;
    private final transient Logger logger;
    private String stylesheet;

    public SpotBugsHtmlReportImpl(String name, Task task) {
        super(name, task);
        this.handler = task.getProject().getResources();
        this.configuration = task.getProject().getConfigurations().getAt("spotbugs");
        this.logger = task.getLogger();
    }

    @Input
    public void setStylesheet(String fileName) {
        this.stylesheet = fileName;
    }

    public TextResource getStylesheet() {
        if (this.stylesheet == null) {
            return super.getStylesheet();
        }
        TextResourceFactory factory = this.handler.getText();
        Optional spotbugs = this.configuration.files(this::find).stream().findFirst();
        if (spotbugs.isPresent()) {
            File jar = (File)spotbugs.get();
            this.logger.debug("Specified stylesheet ({}) found in spotbugs configuration: {}", (Object)this.stylesheet, (Object)jar.getAbsolutePath());
            return factory.fromArchiveEntry((Object)jar, this.stylesheet);
        }
        throw new InvalidUserDataException("Specified stylesheet (" + this.stylesheet + ") was not found in spotbugs configuration");
    }

    private boolean find(Dependency d) {
        return "com.github.spotbugs".equals(d.getGroup()) && "spotbugs".equals(d.getName());
    }
}

