/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs;

import com.github.spotbugs.SpotBugsExtension;
import com.github.spotbugs.SpotBugsTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.util.GradleVersion;

public class SpotBugsPlugin
extends AbstractCodeQualityPlugin<SpotBugsTask> {
    static final GradleVersion SUPPORTED_VERSION = GradleVersion.version((String)"5.2");
    private SpotBugsExtension extension;

    protected String getToolName() {
        return "SpotBugs";
    }

    protected Class<SpotBugsTask> getTaskType() {
        return SpotBugsTask.class;
    }

    protected void beforeApply() {
        this.verifyGradleVersion(GradleVersion.current());
        this.configureSpotBugsConfigurations();
    }

    void verifyGradleVersion(GradleVersion version) throws IllegalArgumentException {
        if (version.compareTo(SUPPORTED_VERSION) < 0) {
            String message = String.format("Gradle version %s is unsupported. Please use %s or later.", version, SUPPORTED_VERSION);
            throw new IllegalArgumentException(message);
        }
    }

    private void configureSpotBugsConfigurations() {
        Configuration configuration = (Configuration)this.project.getConfigurations().create("spotbugsPlugins");
        configuration.setVisible(false);
        configuration.setTransitive(true);
        configuration.setDescription("The SpotBugs plugins to be used for this project.");
    }

    protected CodeQualityExtension createExtension() {
        this.extension = (SpotBugsExtension)((Object)this.project.getExtensions().create("spotbugs", SpotBugsExtension.class, new Object[]{this.project}));
        this.extension.setToolVersion(this.loadToolVersion());
        return this.extension;
    }

    String loadToolVersion() {
        return this.loadVersion("spotbugs-version");
    }

    String loadSlf4jVersion() {
        return this.loadVersion("slf4j-version");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadVersion(String name) {
        URL url = SpotBugsPlugin.class.getClassLoader().getResource("spotbugs-gradle-plugin.properties");
        try (InputStream input = url.openStream();){
            Properties prop = new Properties();
            prop.load(input);
            String string = prop.getProperty(name);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void configureTaskDefaults(SpotBugsTask task, String baseName) {
        task.setPluginClasspath((FileCollection)this.project.getConfigurations().getAt("spotbugsPlugins"));
        Configuration configuration = this.project.getConfigurations().getAt("spotbugs");
        this.configureDefaultDependencies(configuration);
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    protected void configureConfiguration(Configuration configuration) {
    }

    protected void createConfigurations() {
        Configuration configuration = (Configuration)this.project.getConfigurations().create(this.getConfigurationName());
        configuration.setVisible(false);
        configuration.setTransitive(true);
        configuration.setDescription("The " + this.getToolName() + " libraries to be used for this project.");
        configuration.exclude(this.excludeProperties("ant", "ant"));
        configuration.exclude(this.excludeProperties("org.apache.ant", "ant"));
        configuration.exclude(this.excludeProperties("org.apache.ant", "ant-launcher"));
        configuration.exclude(this.excludeProperties("org.slf4j", "jcl-over-slf4j"));
        configuration.exclude(this.excludeProperties("org.slf4j", "log4j-over-slf4j"));
        configuration.exclude(this.excludeProperties("commons-logging", "commons-logging"));
        configuration.exclude(this.excludeProperties("log4j", "log4j"));
        this.configureConfiguration(configuration);
    }

    private Map<String, String> excludeProperties(String group, String module) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("group", group);
        map.put("module", module);
        return map;
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies(dependencies -> {
            dependencies.add((Object)this.project.getDependencies().create((Object)("org.slf4j:slf4j-simple:" + this.loadSlf4jVersion())));
            dependencies.add((Object)this.project.getDependencies().create((Object)("com.github.spotbugs:spotbugs:" + this.extension.getToolVersion())));
        });
    }

    private void configureTaskConventionMapping(Configuration configuration, SpotBugsTask task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("spotbugsClasspath", () -> configuration);
        taskMapping.map("ignoreFailures", () -> ((SpotBugsExtension)this.extension).isIgnoreFailures());
        taskMapping.map("effort", this.extension::getEffort);
        taskMapping.map("reportLevel", this.extension::getReportLevel);
        taskMapping.map("visitors", this.extension::getVisitors);
        taskMapping.map("omitVisitors", this.extension::getOmitVisitors);
        taskMapping.map("excludeFilterConfig", this.extension::getExcludeFilterConfig);
        taskMapping.map("includeFilterConfig", this.extension::getIncludeFilterConfig);
        taskMapping.map("excludeBugsFilterConfig", this.extension::getExcludeBugsFilterConfig);
        taskMapping.map("extraArgs", this.extension::getExtraArgs);
        taskMapping.map("showProgress", this.extension::isShowProgress);
        taskMapping.map("jvmArgs", this.extension::getJvmArgs);
    }

    private void configureReportsConventionMapping(SpotBugsTask task, String baseName) {
        task.getReports().all(report -> {
            ConventionMapping reportMapping = SpotBugsPlugin.conventionMappingOf((Object)report);
            reportMapping.map("enabled", () -> report.getName().equals("xml"));
            reportMapping.map("destination", () -> new File(this.extension.getReportsDir(), baseName + "." + report.getName()));
        });
    }

    protected void configureForSourceSet(SourceSet sourceSet, SpotBugsTask task) {
        task.setDescription("Run SpotBugs analysis for " + sourceSet.getName() + " classes");
        task.setSourceSet(sourceSet);
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("classes", () -> {
            FileCollection presentClassDirs = sourceSet.getOutput().getClassesDirs().filter(File::exists);
            return presentClassDirs.getAsFileTree();
        });
        taskMapping.map("classpath", () -> ((SourceSet)sourceSet).getRuntimeClasspath());
    }
}

