/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.BaseVariant;
import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.SpotBugsTaskFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsTaskFactory;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "generate", "", "project", "Lorg/gradle/api/Project;", "generateForAndroid", "generateForJava", "Companion", "spotbugs-gradle-plugin"})
public final class SpotBugsTaskFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = LoggerFactory.getLogger(SpotBugsTaskFactory.class);

    public final void generate(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.generateForJava(project);
        this.generateForAndroid(project);
    }

    private final void generateForJava(Project project) {
        project.getPlugins().withType(JavaBasePlugin.class).configureEach(arg_0 -> SpotBugsTaskFactory.generateForJava$lambda$0((Function1)new Function1<JavaBasePlugin, Unit>(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ SpotBugsTaskFactory this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(JavaBasePlugin it) {
                ((JavaPluginExtension)this.$project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().all(arg_0 -> generateForJava.1.invoke$lambda$0((Function1)new Function1<SourceSet, Unit>(this.this$0, this.$project){
                    final /* synthetic */ SpotBugsTaskFactory this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull SourceSet sourceSet) {
                        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
                        String name = sourceSet.getTaskName("spotbugs", null);
                        SpotBugsTaskFactory.access$getLog$p(this.this$0).debug("Creating SpotBugsTask for {}", (Object)sourceSet);
                        this.$project.getTasks().register(name, SpotBugsTask.class, arg_0 -> generateForJava.1.invoke$lambda$0((Function1)new Function1<SpotBugsTask, Unit>(sourceSet){
                            final /* synthetic */ SourceSet $sourceSet;
                            {
                                this.$sourceSet = $sourceSet;
                                super(1);
                            }

                            public final void invoke(SpotBugsTask it) {
                                it.getSourceDirs().setFrom((Iterable)this.$sourceSet.getAllSource().getSourceDirectories());
                                it.getClassDirs().setFrom((Iterable)this.$sourceSet.getOutput());
                                it.getAuxClassPaths().setFrom((Iterable)this.$sourceSet.getCompileClasspath());
                                it.setDescription("Run SpotBugs analysis for the source set '" + this.$sourceSet.getName() + '\'');
                            }
                        }, arg_0));
                    }

                    private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private final void generateForAndroid(Project project) {
        Action action2 = arg_0 -> SpotBugsTaskFactory.generateForAndroid$lambda$2(project, this, arg_0);
        project.getPlugins().withId("com.android.application", action2);
        project.getPlugins().withId("com.android.library", action2);
    }

    private static final void generateForJava$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void generateForAndroid$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void generateForAndroid$lambda$2(Project $project, SpotBugsTaskFactory this$0, Plugin it) {
        DomainObjectSet domainObjectSet;
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BaseExtension baseExtension = (BaseExtension)$project.getExtensions().getByType(BaseExtension.class);
        if (baseExtension instanceof AppExtension) {
            domainObjectSet = ((AppExtension)baseExtension).getApplicationVariants();
        } else if (baseExtension instanceof LibraryExtension) {
            domainObjectSet = (DomainObjectSet)((LibraryExtension)baseExtension).getLibraryVariants();
        } else {
            throw new GradleException("Unrecognized Android extension " + baseExtension);
        }
        DomainObjectSet variants = domainObjectSet;
        variants.all(arg_0 -> SpotBugsTaskFactory.generateForAndroid$lambda$2$lambda$1((Function1)new Function1<BaseVariant, Unit>(this$0, $project){
            final /* synthetic */ SpotBugsTaskFactory this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull BaseVariant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                String spotbugsTaskName = SpotBugsTaskFactory.Companion.toLowerCamelCase("spotbugs", variant.getName());
                SpotBugsTaskFactory.access$getLog$p(this.this$0).debug("Creating SpotBugsTask for {}", (Object)variant.getName());
                this.$project.getTasks().register(spotbugsTaskName, SpotBugsTask.class, arg_0 -> generateForAndroid.action.1.1.invoke$lambda$0((Function1)new Function1<SpotBugsTask, Unit>(variant){
                    final /* synthetic */ BaseVariant $variant;
                    {
                        this.$variant = $variant;
                        super(1);
                    }

                    public final void invoke(SpotBugsTask it) {
                        JavaCompile javaCompile = (JavaCompile)this.$variant.getJavaCompileProvider().get();
                        it.getSourceDirs().setFrom((Iterable)javaCompile.getSource());
                        Object[] objectArray = new Object[]{javaCompile.getDestinationDirectory()};
                        it.getClassDirs().setFrom(objectArray);
                        it.getAuxClassPaths().setFrom((Iterable)javaCompile.getClasspath());
                        objectArray = new Object[]{javaCompile};
                        it.dependsOn(objectArray);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    public static final /* synthetic */ Logger access$getLog$p(SpotBugsTaskFactory $this) {
        return $this.log;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0007"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsTaskFactory$Companion;", "", "()V", "toLowerCamelCase", "", "head", "tail", "spotbugs-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String toLowerCamelCase(@NotNull String head, @Nullable String tail) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)head, (String)"head");
            CharSequence charSequence = tail;
            if (charSequence == null || charSequence.length() == 0) {
                return head;
            }
            int n = head.length() + tail.length();
            StringBuilder $this$toLowerCamelCase_u24lambda_u240 = stringBuilder = new StringBuilder(n);
            boolean bl = false;
            $this$toLowerCamelCase_u24lambda_u240.append(head);
            $this$toLowerCamelCase_u24lambda_u240.append(Character.toUpperCase(tail.charAt(0)));
            String string = tail.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$toLowerCamelCase_u24lambda_u240.append(string);
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

