/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.OutputScanner;
import com.github.spotbugs.snom.internal.SpotBugsRunner;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaExecSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpotBugsRunnerForHybrid
extends SpotBugsRunner {
    private final WorkerExecutor workerExecutor;
    private final Property<JavaLauncher> javaLauncher;
    private static final int MISSING_CLASS_FLAG = 2;

    public SpotBugsRunnerForHybrid(@NonNull WorkerExecutor workerExecutor, Property<JavaLauncher> javaLauncher) {
        this.workerExecutor = Objects.requireNonNull(workerExecutor);
        this.javaLauncher = javaLauncher;
    }

    @Override
    public void run(@NonNull SpotBugsTask task) {
        this.workerExecutor.noIsolation().submit(SpotBugsExecutor.class, this.configureWorkerSpec(task));
    }

    private Action<SpotBugsWorkParameters> configureWorkerSpec(SpotBugsTask task) {
        return params -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-exitcode");
            args.addAll(this.buildArguments(task));
            params.getClasspath().setFrom((Iterable)task.getSpotbugsClasspath());
            params.getJvmArgs().set(this.buildJvmArguments(task));
            params.getArgs().set(args);
            String maxHeapSize = (String)task.getMaxHeapSize().getOrNull();
            if (maxHeapSize != null) {
                params.getMaxHeapSize().set((Object)maxHeapSize);
            }
            params.getIgnoreFailures().set((Object)task.getIgnoreFailures());
            params.getShowStackTraces().set((Object)task.getShowStackTraces());
            task.getEnabledReports().stream().map(SpotBugsReport::getOutputLocation).forEach(arg_0 -> params.getReports().add(arg_0));
            if (this.javaLauncher.isPresent()) {
                params.getJavaToolchainExecutablePath().set((Object)((JavaLauncher)this.javaLauncher.get()).getExecutablePath().getAsFile().getAbsolutePath());
            }
        };
    }

    public static abstract class SpotBugsExecutor
    implements WorkAction<SpotBugsWorkParameters> {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final ExecOperations execOperations;
        private OutputScanner stderrOutputScanner;

        @Inject
        public SpotBugsExecutor(ExecOperations execOperations) {
            this.execOperations = Objects.requireNonNull(execOperations);
        }

        public void execute() {
            SpotBugsWorkParameters params = (SpotBugsWorkParameters)this.getParameters();
            int exitValue = this.execOperations.javaexec(this.configureJavaExec(params)).rethrowFailure().getExitValue();
            boolean ignoreFailures = (Boolean)params.getIgnoreFailures().getOrElse((Object)Boolean.FALSE);
            if (this.ignoreMissingClassFlag(exitValue) == 0) {
                if (this.stderrOutputScanner.isFailedToReport() && !ignoreFailures) {
                    throw new GradleException("SpotBugs analysis succeeded but report generation failed");
                }
                return;
            }
            if (ignoreFailures) {
                this.log.warn("SpotBugs ended with exit code " + exitValue);
                return;
            }
            String errorMessage = "Verification failed: SpotBugs ended with exit code " + exitValue + ".";
            List reportPaths = ((List)params.getReports().get()).stream().map(RegularFile::getAsFile).map(File::toPath).map(Path::toUri).map(URI::toString).collect(Collectors.toList());
            if (!reportPaths.isEmpty()) {
                errorMessage = errorMessage + " See the report at: " + String.join((CharSequence)",", reportPaths);
            }
            throw new GradleException(errorMessage);
        }

        private int ignoreMissingClassFlag(int exitValue) {
            if ((exitValue & 2) == 0) {
                return exitValue;
            }
            this.log.debug("MISSING_CLASS_FLAG (2) was set to the exit code, but ignore it to keep the task result stable.");
            return exitValue ^ 2;
        }

        private Action<? super JavaExecSpec> configureJavaExec(SpotBugsWorkParameters params) {
            return spec -> {
                spec.setJvmArgs((List)params.getJvmArgs().get());
                spec.classpath(new Object[]{params.getClasspath()});
                spec.setArgs((List)params.getArgs().get());
                spec.getMainClass().set((Object)"edu.umd.cs.findbugs.FindBugs2");
                String maxHeapSize = (String)params.getMaxHeapSize().getOrNull();
                if (maxHeapSize != null) {
                    spec.setMaxHeapSize(maxHeapSize);
                }
                if (params.getJavaToolchainExecutablePath().isPresent()) {
                    this.log.info("Spotbugs will be executed using Java Toolchain configuration: {}", params.getJavaToolchainExecutablePath().get());
                    spec.setExecutable((String)params.getJavaToolchainExecutablePath().get());
                }
                spec.setIgnoreExitValue(true);
                this.stderrOutputScanner = new OutputScanner(System.err);
                spec.setErrorOutput((OutputStream)this.stderrOutputScanner);
            };
        }
    }

    public static interface SpotBugsWorkParameters
    extends WorkParameters {
        public ConfigurableFileCollection getClasspath();

        public Property<String> getMaxHeapSize();

        public ListProperty<String> getArgs();

        public ListProperty<String> getJvmArgs();

        public Property<Boolean> getIgnoreFailures();

        public Property<Boolean> getShowStackTraces();

        public Property<String> getJavaToolchainExecutablePath();

        public ListProperty<RegularFile> getReports();
    }
}

