/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.Confidence;
import com.github.spotbugs.snom.Effort;
import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpotBugsRunner {
    private final Logger log = LoggerFactory.getLogger(SpotBugsRunner.class);

    public abstract void run(@NonNull SpotBugsTask var1);

    protected List<String> buildArguments(SpotBugsTask task) {
        SpotBugsReport report;
        ArrayList<String> args = new ArrayList<String>();
        Set<File> plugins = task.getPluginJar();
        if (!plugins.isEmpty()) {
            args.add("-pluginList");
            args.add(this.join(plugins));
        }
        args.add("-sortByClass");
        args.add("-timestampNow");
        if (!task.getAuxClassPaths().isEmpty()) {
            if (((Boolean)task.getUseAuxclasspathFile().get()).booleanValue()) {
                args.add("-auxclasspathFromFile");
                String auxClasspathFile = this.createFileForAuxClasspath(task);
                this.log.debug("Using auxclasspath file: {}", (Object)auxClasspathFile);
                args.add(auxClasspathFile);
            } else {
                args.add("-auxclasspath");
                args.add(this.join(task.getAuxClassPaths().getFiles()));
            }
        }
        if (!task.getSourceDirs().isEmpty()) {
            args.add("-sourcepath");
            args.add(task.getSourceDirs().getAsPath());
        }
        if (((Boolean)task.getShowProgress().getOrElse((Object)Boolean.FALSE)).booleanValue()) {
            args.add("-progress");
        }
        if ((report = task.getFirstEnabledReport()) != null) {
            File outputLocation = (File)report.getOutputLocation().map(RegularFile::getAsFile).get();
            File dir = outputLocation.getParentFile();
            dir.mkdirs();
            report.toCommandLineOption().ifPresent(args::add);
            args.add("-outputFile");
            args.add(outputLocation.getAbsolutePath());
        }
        if (task.getEffort().isPresent()) {
            args.add("-effort:" + ((Effort)((Object)task.getEffort().get())).name().toLowerCase());
        }
        if (task.getReportLevel().isPresent()) {
            ((Confidence)((Object)task.getReportLevel().get())).toCommandLineOption().ifPresent(args::add);
        }
        if (task.getVisitors().isPresent() && !((List)task.getVisitors().get()).isEmpty()) {
            args.add("-visitors");
            args.add(((List)task.getVisitors().get()).stream().collect(Collectors.joining(",")));
        }
        if (task.getOmitVisitors().isPresent() && !((List)task.getOmitVisitors().get()).isEmpty()) {
            args.add("-omitVisitors");
            args.add(((List)task.getOmitVisitors().get()).stream().collect(Collectors.joining(",")));
        }
        if (task.getIncludeFilter().isPresent() && task.getIncludeFilter().get() != null) {
            args.add("-include");
            args.add(((RegularFile)task.getIncludeFilter().get()).getAsFile().getAbsolutePath());
        }
        if (task.getExcludeFilter().isPresent() && task.getExcludeFilter().get() != null) {
            args.add("-exclude");
            args.add(((RegularFile)task.getExcludeFilter().get()).getAsFile().getAbsolutePath());
        }
        if (task.getBaselineFile().isPresent() && task.getBaselineFile().get() != null) {
            args.add("-excludeBugs");
            args.add(((RegularFile)task.getBaselineFile().get()).getAsFile().getAbsolutePath());
        }
        if (task.getOnlyAnalyze().isPresent() && !((List)task.getOnlyAnalyze().get()).isEmpty()) {
            args.add("-onlyAnalyze");
            args.add(((List)task.getOnlyAnalyze().get()).stream().collect(Collectors.joining(",")));
        }
        args.add("-projectName");
        args.add((String)task.getProjectName().get());
        args.add("-release");
        args.add((String)task.getRelease().get());
        args.add("-analyzeFromFile");
        args.add(this.generateFile(task.getClasses(), (Task)task).getAbsolutePath());
        args.addAll((Collection)task.getExtraArgs().getOrElse(Collections.emptyList()));
        this.log.debug("Arguments for SpotBugs are generated: {}", args);
        return args;
    }

    private String createFileForAuxClasspath(SpotBugsTask task) {
        String auxClasspath = task.getAuxClassPaths().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.joining("\n"));
        try {
            Path auxClasspathFile = Paths.get(task.getProject().getBuildDir().getAbsolutePath(), "spotbugs", "auxclasspath", task.getName());
            try {
                Files.createDirectories(auxClasspathFile.getParent(), new FileAttribute[0]);
                if (!Files.exists(auxClasspathFile, new LinkOption[0])) {
                    Files.createFile(auxClasspathFile, new FileAttribute[0]);
                }
                Files.write(auxClasspathFile, auxClasspath.getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
                return auxClasspathFile.normalize().toString();
            }
            catch (Exception e) {
                throw new GradleException("Could not create auxiliary classpath file for SpotBugsTask at " + auxClasspathFile.normalize().toString(), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new GradleException("Could not create auxiliary classpath file for SpotBugsTask", (Throwable)e);
        }
    }

    private File generateFile(FileCollection files, Task task) {
        try {
            File file = File.createTempFile("spotbugs-gradle-plugin", ".txt", task.getTemporaryDir());
            Iterable lines = files.filter(File::exists).getFiles().stream().map(File::getAbsolutePath)::iterator;
            Files.write(file.toPath(), lines, StandardCharsets.UTF_8, StandardOpenOption.WRITE);
            return file;
        }
        catch (IOException e) {
            throw new GradleException("Fail to generate the text file to list target .class files", (Throwable)e);
        }
    }

    protected List<String> buildJvmArguments(SpotBugsTask task) {
        List args = (List)task.getJvmArgs().getOrElse(Collections.emptyList());
        this.log.debug("Arguments for JVM process are generated: {}", (Object)args);
        return args;
    }

    private String join(Collection<File> files) {
        return files.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
    }
}

