/*
 * Decompiled with CFR 0.152.
 */
package com.sqsong.qrcodelib.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.google.zxing.ResultPoint;
import com.sqsong.qrcodelib.R;
import com.sqsong.qrcodelib.camera.CameraManager;
import com.sqsong.qrcodelib.util.DensityUtil;
import java.util.ArrayList;
import java.util.List;

public class QRCodeScanView
extends View {
    private static final int POINT_SIZE = 6;
    private static final int MAX_RESULT_POINTS = 20;
    private static final long ANIMATION_DELAY = 50L;
    private static final int CORNER_BORDER_WIDTH = 8;
    private static final int CURRENT_POINT_OPACITY = 160;
    private static final int CENTER_LINE_MOVE_DISTANCE = 8;
    private static final int HALF_CORNER_BORDER_WIDTH = 4;
    private Path mPath;
    private Paint mPaint;
    private int mMuskColor;
    private Rect mScanRect;
    private int mBorderColor;
    private int mCornerHeight;
    private Paint mBorderPaint;
    private int mCenterLineTop;
    private int mCenterLineColor;
    private int mResultPointColor;
    private Rect mPreviewScanRect;
    private int mCenterLineHeight;
    private CameraManager mCameraManager;
    private List<ResultPoint> possibleResultPoints;
    private List<ResultPoint> lastPossibleResultPoints;

    public QRCodeScanView(Context context) {
        this(context, null);
    }

    public QRCodeScanView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QRCodeScanView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initParams(context, attrs);
        this.init();
    }

    private void initParams(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.QRCodeScanView);
        this.mMuskColor = ta.getColor(R.styleable.QRCodeScanView_muskColor, this.getResources().getColor(R.color.colorMusk));
        this.mBorderColor = ta.getColor(R.styleable.QRCodeScanView_cornerBorderColor, this.getResources().getColor(R.color.colorAccent));
        this.mCenterLineColor = ta.getColor(R.styleable.QRCodeScanView_centerLineColor, this.getResources().getColor(R.color.colorAccent));
        this.mResultPointColor = ta.getColor(R.styleable.QRCodeScanView_resultPointColor, this.getResources().getColor(R.color.colorPossiblePoints));
        this.mCornerHeight = (int)ta.getDimension(R.styleable.QRCodeScanView_borderHeight, 0.0f);
        this.mCenterLineHeight = (int)ta.getDimension(R.styleable.QRCodeScanView_centerLineHeight, (float)DensityUtil.dip2px(1.0f));
        ta.recycle();
    }

    private void init() {
        this.possibleResultPoints = new ArrayList<ResultPoint>(5);
        this.lastPossibleResultPoints = null;
        this.mPaint = new Paint(1);
        this.mBorderPaint = new Paint(1);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mPath = new Path();
        this.mScanRect = new Rect();
    }

    public void setCameraManager(CameraManager cameraManager) {
        this.mCameraManager = cameraManager;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mCameraManager == null) {
            return;
        }
        this.mScanRect = this.mCameraManager.getFramingRect();
        this.mPreviewScanRect = this.mCameraManager.getFramingRectInPreview();
        if (this.mScanRect == null || this.mPreviewScanRect == null) {
            return;
        }
        if (this.mCornerHeight == 0) {
            this.mCornerHeight = (int)((float)(this.mScanRect.right - this.mScanRect.left) * 1.0f / 10.0f);
        }
        if (this.mCenterLineTop == 0) {
            this.mCenterLineTop = this.mScanRect.top + 4;
        }
        this.drawMusk(canvas);
        this.drawFourCorner(canvas);
        this.drawCenterLine(canvas);
        this.drawPossiblePoints(canvas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawPossiblePoints(Canvas canvas) {
        List<ResultPoint> list;
        float scaleX = (float)this.mScanRect.width() / (float)this.mPreviewScanRect.width();
        float scaleY = (float)this.mScanRect.height() / (float)this.mPreviewScanRect.height();
        List<ResultPoint> currentPossible = this.possibleResultPoints;
        List<ResultPoint> currentLast = this.lastPossibleResultPoints;
        int frameLeft = this.mScanRect.left;
        int frameTop = this.mScanRect.top;
        if (currentPossible.isEmpty()) {
            this.lastPossibleResultPoints = null;
        } else {
            this.possibleResultPoints = new ArrayList<ResultPoint>(5);
            this.lastPossibleResultPoints = currentPossible;
            this.mPaint.setAlpha(160);
            this.mPaint.setColor(this.mResultPointColor);
            list = currentPossible;
            synchronized (list) {
                for (ResultPoint point : currentPossible) {
                    canvas.drawCircle((float)(frameLeft + (int)(point.getX() * scaleX)), (float)(frameTop + (int)(point.getY() * scaleY)), 6.0f, this.mPaint);
                }
            }
        }
        if (currentLast != null) {
            this.mPaint.setAlpha(80);
            this.mPaint.setColor(this.mResultPointColor);
            list = currentLast;
            synchronized (list) {
                float radius = 3.0f;
                for (ResultPoint point : currentLast) {
                    canvas.drawCircle((float)(frameLeft + (int)(point.getX() * scaleX)), (float)(frameTop + (int)(point.getY() * scaleY)), radius, this.mPaint);
                }
            }
        }
        this.postInvalidateDelayed(50L, this.mScanRect.left, this.mScanRect.top, this.mScanRect.right, this.mScanRect.bottom);
    }

    private void drawCenterLine(Canvas canvas) {
        this.mCenterLineTop += 8;
        if (this.mCenterLineTop > this.mScanRect.bottom - 4) {
            this.mCenterLineTop = this.mScanRect.top + 4;
        }
        this.mPaint.setColor(this.mCenterLineColor);
        canvas.drawRect((float)(this.mScanRect.left + 4), (float)this.mCenterLineTop, (float)(this.mScanRect.right - 4), (float)(this.mCenterLineTop + this.mCenterLineHeight), this.mPaint);
    }

    private void drawFourCorner(Canvas canvas) {
        this.mPath.reset();
        this.mPath.moveTo((float)(this.mScanRect.left - 4), (float)(this.mScanRect.top + this.mCornerHeight));
        this.mPath.lineTo((float)(this.mScanRect.left - 4), (float)(this.mScanRect.top - 4));
        this.mPath.lineTo((float)(this.mScanRect.left + this.mCornerHeight), (float)(this.mScanRect.top - 4));
        this.mPath.moveTo((float)(this.mScanRect.right - this.mCornerHeight), (float)(this.mScanRect.top - 4));
        this.mPath.lineTo((float)(this.mScanRect.right + 4), (float)(this.mScanRect.top - 4));
        this.mPath.lineTo((float)(this.mScanRect.right + 4), (float)(this.mScanRect.top + this.mCornerHeight));
        this.mPath.moveTo((float)(this.mScanRect.right + 4), (float)(this.mScanRect.bottom - this.mCornerHeight));
        this.mPath.lineTo((float)(this.mScanRect.right + 4), (float)(this.mScanRect.bottom + 4));
        this.mPath.lineTo((float)(this.mScanRect.right - this.mCornerHeight), (float)(this.mScanRect.bottom + 4));
        this.mPath.moveTo((float)(this.mScanRect.left + this.mCornerHeight), (float)(this.mScanRect.bottom + 4));
        this.mPath.lineTo((float)(this.mScanRect.left - 4), (float)(this.mScanRect.bottom + 4));
        this.mPath.lineTo((float)(this.mScanRect.left - 4), (float)(this.mScanRect.bottom - this.mCornerHeight));
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setStrokeWidth(8.0f);
        canvas.drawPath(this.mPath, this.mBorderPaint);
    }

    private void drawMusk(Canvas canvas) {
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.mPaint.setColor(this.mMuskColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)this.mScanRect.top, this.mPaint);
        canvas.drawRect(0.0f, (float)this.mScanRect.top, (float)this.mScanRect.left, (float)this.mScanRect.bottom, this.mPaint);
        canvas.drawRect((float)this.mScanRect.right, (float)this.mScanRect.top, (float)width, (float)this.mScanRect.bottom, this.mPaint);
        canvas.drawRect(0.0f, (float)this.mScanRect.bottom, (float)width, (float)height, this.mPaint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPossibleResultPoint(ResultPoint point) {
        List<ResultPoint> points;
        List<ResultPoint> list = points = this.possibleResultPoints;
        synchronized (list) {
            points.add(point);
            int size = points.size();
            if (size > 20) {
                points.subList(0, size - 10).clear();
            }
        }
    }
}

