/*
 * Decompiled with CFR 0.152.
 */
package com.sqsong.qrcodelib.camera;

import android.content.Context;
import android.util.Log;
import android.view.SurfaceHolder;
import com.sqsong.qrcodelib.camera.CameraManager;
import com.sqsong.qrcodelib.camera.QRCodeDecodeCallback;
import com.sqsong.qrcodelib.camera.QRCodeDecodeHandler;
import java.io.IOException;

public class QRCodeManager
implements SurfaceHolder.Callback {
    private static final String TAG = QRCodeManager.class.getSimpleName();
    private Context mContext;
    private boolean hasSurface;
    private CameraManager mCameraManager;
    private QRCodeDecodeCallback mCallback;
    private QRCodeDecodeHandler mDecodeHandler;

    public QRCodeManager(Context context, QRCodeDecodeCallback callback) {
        this.mContext = context;
        this.mCallback = callback;
    }

    public void onResume(SurfaceHolder surfaceHolder) {
        if (surfaceHolder == null) {
            throw new IllegalArgumentException("The surface holder must not be null.");
        }
        this.mCameraManager = new CameraManager(this.mContext);
        if (this.mCallback != null) {
            this.mCallback.cameraManagerInitFinish(this.mCameraManager);
        }
        this.mDecodeHandler = null;
        if (this.hasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        }
    }

    public void onPause(SurfaceHolder surfaceHolder) {
        if (this.mDecodeHandler != null) {
            this.mDecodeHandler.quitSynchronously();
            this.mDecodeHandler = null;
        }
        this.mCameraManager.closeDriver();
        if (!this.hasSurface) {
            surfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        if (surfaceHolder == null) {
            throw new IllegalArgumentException("The surface holder must not be null.");
        }
        if (this.mCameraManager.isOpen()) {
            Log.w((String)TAG, (String)"initCamera() while already open -- late SurfaceView callback?");
            return;
        }
        try {
            this.mCameraManager.openDriver(surfaceHolder);
            if (this.mDecodeHandler == null) {
                this.mDecodeHandler = new QRCodeDecodeHandler(this.mCameraManager, this.mCallback);
            }
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (Throwable)ioe);
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)"Unexpected error initializing camera", (Throwable)e);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (holder == null) {
            return;
        }
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    public void startScanning() {
        if (this.mDecodeHandler != null) {
            this.mDecodeHandler.sendEmptyMessageDelayed(0, 0L);
        }
    }

    public void openFlash(boolean open) {
        if (this.mCameraManager != null) {
            this.mCameraManager.setTorch(open);
        }
    }
}

