/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider.IndicatorView.animation.type;

import android.animation.IntEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.smarteist.autoimageslider.IndicatorView.animation.controller.ValueController;
import com.smarteist.autoimageslider.IndicatorView.animation.data.type.ScaleAnimationValue;
import com.smarteist.autoimageslider.IndicatorView.animation.type.ColorAnimation;

public class ScaleAnimation
extends ColorAnimation {
    public static final float DEFAULT_SCALE_FACTOR = 0.7f;
    public static final float MIN_SCALE_FACTOR = 0.3f;
    public static final float MAX_SCALE_FACTOR = 1.0f;
    static final String ANIMATION_SCALE_REVERSE = "ANIMATION_SCALE_REVERSE";
    static final String ANIMATION_SCALE = "ANIMATION_SCALE";
    int radius;
    float scaleFactor;
    private ScaleAnimationValue value = new ScaleAnimationValue();

    public ScaleAnimation(@NonNull ValueController.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public ValueAnimator createAnimator() {
        ValueAnimator animator = new ValueAnimator();
        animator.setDuration(350L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ScaleAnimation.this.onAnimateUpdated(animation);
            }
        });
        return animator;
    }

    @NonNull
    public ScaleAnimation with(int colorStart, int colorEnd, int radius, float scaleFactor) {
        if (this.animator != null && this.hasChanges(colorStart, colorEnd, radius, scaleFactor)) {
            this.colorStart = colorStart;
            this.colorEnd = colorEnd;
            this.radius = radius;
            this.scaleFactor = scaleFactor;
            PropertyValuesHolder colorHolder = this.createColorPropertyHolder(false);
            PropertyValuesHolder reverseColorHolder = this.createColorPropertyHolder(true);
            PropertyValuesHolder scaleHolder = this.createScalePropertyHolder(false);
            PropertyValuesHolder scaleReverseHolder = this.createScalePropertyHolder(true);
            ((ValueAnimator)this.animator).setValues(new PropertyValuesHolder[]{colorHolder, reverseColorHolder, scaleHolder, scaleReverseHolder});
        }
        return this;
    }

    private void onAnimateUpdated(@NonNull ValueAnimator animation) {
        int color = (Integer)animation.getAnimatedValue("ANIMATION_COLOR");
        int colorReverse = (Integer)animation.getAnimatedValue("ANIMATION_COLOR_REVERSE");
        int radius = (Integer)animation.getAnimatedValue(ANIMATION_SCALE);
        int radiusReverse = (Integer)animation.getAnimatedValue(ANIMATION_SCALE_REVERSE);
        this.value.setColor(color);
        this.value.setColorReverse(colorReverse);
        this.value.setRadius(radius);
        this.value.setRadiusReverse(radiusReverse);
        if (this.listener != null) {
            this.listener.onValueUpdated(this.value);
        }
    }

    @NonNull
    protected PropertyValuesHolder createScalePropertyHolder(boolean isReverse) {
        int endRadiusValue;
        int startRadiusValue;
        String propertyName;
        if (isReverse) {
            propertyName = ANIMATION_SCALE_REVERSE;
            startRadiusValue = this.radius;
            endRadiusValue = (int)((float)this.radius * this.scaleFactor);
        } else {
            propertyName = ANIMATION_SCALE;
            startRadiusValue = (int)((float)this.radius * this.scaleFactor);
            endRadiusValue = this.radius;
        }
        PropertyValuesHolder holder = PropertyValuesHolder.ofInt((String)propertyName, (int[])new int[]{startRadiusValue, endRadiusValue});
        holder.setEvaluator((TypeEvaluator)new IntEvaluator());
        return holder;
    }

    private boolean hasChanges(int colorStart, int colorEnd, int radiusValue, float scaleFactorValue) {
        if (this.colorStart != colorStart) {
            return true;
        }
        if (this.colorEnd != colorEnd) {
            return true;
        }
        if (this.radius != radiusValue) {
            return true;
        }
        return this.scaleFactor != scaleFactorValue;
    }
}

