/*
 * Decompiled with CFR 0.152.
 */
package com.smarteist.autoimageslider.IndicatorView.animation.type;

import android.animation.IntEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.smarteist.autoimageslider.IndicatorView.animation.controller.ValueController;
import com.smarteist.autoimageslider.IndicatorView.animation.data.type.FillAnimationValue;
import com.smarteist.autoimageslider.IndicatorView.animation.type.ColorAnimation;

public class FillAnimation
extends ColorAnimation {
    private static final String ANIMATION_RADIUS_REVERSE = "ANIMATION_RADIUS_REVERSE";
    private static final String ANIMATION_RADIUS = "ANIMATION_RADIUS";
    private static final String ANIMATION_STROKE_REVERSE = "ANIMATION_STROKE_REVERSE";
    private static final String ANIMATION_STROKE = "ANIMATION_STROKE";
    public static final int DEFAULT_STROKE_DP = 1;
    private FillAnimationValue value = new FillAnimationValue();
    private int radius;
    private int stroke;

    public FillAnimation(@NonNull ValueController.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public ValueAnimator createAnimator() {
        ValueAnimator animator = new ValueAnimator();
        animator.setDuration(350L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FillAnimation.this.onAnimateUpdated(animation);
            }
        });
        return animator;
    }

    @NonNull
    public FillAnimation with(int colorStart, int colorEnd, int radius, int stroke) {
        if (this.animator != null && this.hasChanges(colorStart, colorEnd, radius, stroke)) {
            this.colorStart = colorStart;
            this.colorEnd = colorEnd;
            this.radius = radius;
            this.stroke = stroke;
            PropertyValuesHolder colorHolder = this.createColorPropertyHolder(false);
            PropertyValuesHolder reverseColorHolder = this.createColorPropertyHolder(true);
            PropertyValuesHolder radiusHolder = this.createRadiusPropertyHolder(false);
            PropertyValuesHolder radiusReverseHolder = this.createRadiusPropertyHolder(true);
            PropertyValuesHolder strokeHolder = this.createStrokePropertyHolder(false);
            PropertyValuesHolder strokeReverseHolder = this.createStrokePropertyHolder(true);
            ((ValueAnimator)this.animator).setValues(new PropertyValuesHolder[]{colorHolder, reverseColorHolder, radiusHolder, radiusReverseHolder, strokeHolder, strokeReverseHolder});
        }
        return this;
    }

    @NonNull
    private PropertyValuesHolder createRadiusPropertyHolder(boolean isReverse) {
        int endRadiusValue;
        int startRadiusValue;
        String propertyName;
        if (isReverse) {
            propertyName = ANIMATION_RADIUS_REVERSE;
            startRadiusValue = this.radius / 2;
            endRadiusValue = this.radius;
        } else {
            propertyName = ANIMATION_RADIUS;
            startRadiusValue = this.radius;
            endRadiusValue = this.radius / 2;
        }
        PropertyValuesHolder holder = PropertyValuesHolder.ofInt((String)propertyName, (int[])new int[]{startRadiusValue, endRadiusValue});
        holder.setEvaluator((TypeEvaluator)new IntEvaluator());
        return holder;
    }

    @NonNull
    private PropertyValuesHolder createStrokePropertyHolder(boolean isReverse) {
        int endStrokeValue;
        int startStrokeValue;
        String propertyName;
        if (isReverse) {
            propertyName = ANIMATION_STROKE_REVERSE;
            startStrokeValue = this.radius;
            endStrokeValue = 0;
        } else {
            propertyName = ANIMATION_STROKE;
            startStrokeValue = 0;
            endStrokeValue = this.radius;
        }
        PropertyValuesHolder holder = PropertyValuesHolder.ofInt((String)propertyName, (int[])new int[]{startStrokeValue, endStrokeValue});
        holder.setEvaluator((TypeEvaluator)new IntEvaluator());
        return holder;
    }

    private void onAnimateUpdated(@NonNull ValueAnimator animation) {
        int color = (Integer)animation.getAnimatedValue("ANIMATION_COLOR");
        int colorReverse = (Integer)animation.getAnimatedValue("ANIMATION_COLOR_REVERSE");
        int radius = (Integer)animation.getAnimatedValue(ANIMATION_RADIUS);
        int radiusReverse = (Integer)animation.getAnimatedValue(ANIMATION_RADIUS_REVERSE);
        int stroke = (Integer)animation.getAnimatedValue(ANIMATION_STROKE);
        int strokeReverse = (Integer)animation.getAnimatedValue(ANIMATION_STROKE_REVERSE);
        this.value.setColor(color);
        this.value.setColorReverse(colorReverse);
        this.value.setRadius(radius);
        this.value.setRadiusReverse(radiusReverse);
        this.value.setStroke(stroke);
        this.value.setStrokeReverse(strokeReverse);
        if (this.listener != null) {
            this.listener.onValueUpdated(this.value);
        }
    }

    private boolean hasChanges(int colorStart, int colorEnd, int radiusValue, int strokeValue) {
        if (this.colorStart != colorStart) {
            return true;
        }
        if (this.colorEnd != colorEnd) {
            return true;
        }
        if (this.radius != radiusValue) {
            return true;
        }
        return this.stroke != strokeValue;
    }
}

