/*
 * Decompiled with CFR 0.152.
 */
package com.github.slashrootv200.exoplayerfragment;

import android.text.TextUtils;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.util.MimeTypes;
import java.util.Locale;

final class ExoUtils {
    private ExoUtils() {
    }

    public static String buildTrackName(Format format) {
        String trackName = MimeTypes.isVideo((String)format.sampleMimeType) ? ExoUtils.joinWithSeparator(ExoUtils.joinWithSeparator(ExoUtils.joinWithSeparator(ExoUtils.buildResolutionString(format), ExoUtils.buildBitrateString(format)), ExoUtils.buildTrackIdString(format)), ExoUtils.buildSampleMimeTypeString(format)) : (MimeTypes.isAudio((String)format.sampleMimeType) ? ExoUtils.joinWithSeparator(ExoUtils.joinWithSeparator(ExoUtils.joinWithSeparator(ExoUtils.joinWithSeparator(ExoUtils.buildLanguageString(format), ExoUtils.buildAudioPropertyString(format)), ExoUtils.buildBitrateString(format)), ExoUtils.buildTrackIdString(format)), ExoUtils.buildSampleMimeTypeString(format)) : ExoUtils.joinWithSeparator(ExoUtils.joinWithSeparator(ExoUtils.joinWithSeparator(ExoUtils.buildLanguageString(format), ExoUtils.buildBitrateString(format)), ExoUtils.buildTrackIdString(format)), ExoUtils.buildSampleMimeTypeString(format)));
        return trackName.length() == 0 ? "unknown" : trackName;
    }

    private static String buildResolutionString(Format format) {
        return format.width == -1 || format.height == -1 ? "" : format.width + "x" + format.height;
    }

    private static String buildAudioPropertyString(Format format) {
        return format.channelCount == -1 || format.sampleRate == -1 ? "" : format.channelCount + "ch, " + format.sampleRate + "Hz";
    }

    private static String buildLanguageString(Format format) {
        return TextUtils.isEmpty((CharSequence)format.language) || "und".equals(format.language) ? "" : format.language;
    }

    private static String buildBitrateString(Format format) {
        return format.bitrate == -1 ? "" : String.format(Locale.US, "%.2fMbit", Float.valueOf((float)format.bitrate / 1000000.0f));
    }

    private static String joinWithSeparator(String first, String second) {
        return first.length() == 0 ? second : (second.length() == 0 ? first : first + ", " + second);
    }

    private static String buildTrackIdString(Format format) {
        return format.id == null ? "" : "id:" + format.id;
    }

    private static String buildSampleMimeTypeString(Format format) {
        return format.sampleMimeType == null ? "" : format.sampleMimeType;
    }
}

