/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio;

import org.apache.commons.lang.StringUtils;

public class Options {
    private String host;
    private int maxQueueSize;
    private int timeout;

    public Options() {
        this("https://api.segment.io", 10000, 10000);
    }

    Options(String host, int maxQueueSize, int timeout) {
        this.setHost(host);
        this.setMaxQueueSize(maxQueueSize);
        this.setTimeout(timeout);
    }

    public String getHost() {
        return this.host;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Options setMaxQueueSize(int maxQueueSize) {
        if (maxQueueSize < 1) {
            throw new IllegalArgumentException("Analytics#option#maxQueueSize must be greater than 0.");
        }
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    public Options setHost(String host) {
        if (StringUtils.isEmpty((String)host)) {
            throw new IllegalArgumentException("Analytics#option#host must be a valid host, like 'https://api.segment.io'.");
        }
        this.host = host;
        return this;
    }

    public Options setTimeout(int timeout) {
        if (timeout < 1000) {
            throw new IllegalArgumentException("Analytics#option#timeout must be at least 1000 milliseconds.");
        }
        this.timeout = timeout;
        return this;
    }
}

