/*
 * Decompiled with CFR 0.152.
 */
package de.mxapplications.openfiledialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import de.mxapplications.openfiledialog.R;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class OpenFileDialog
extends Dialog {
    protected final String PARENT_FOLDER = "..";
    private TextView mTitleTextView = null;
    private TextView mPathTextView = null;
    private RecyclerView mFileListView = null;
    private Button mOkButton = null;
    private Button mCancelButton = null;
    private FileListRecyclerViewAdapter mFileListAdapter = null;
    private int mFolderIcon = R.drawable.ic_folder_black_48dp;
    private int mFileIcon = R.drawable.ic_insert_drive_file_black_48dp;
    private int mFolderUpIcon = R.drawable.ic_keyboard_backspace_black_48dp;
    private int mFileSelectedBackgroundColor;
    private int mFileSelectedColor;
    private boolean mFolderSelectable = false;
    private String mPath;
    private FileItem mSelectedFile;
    private String mTitle;
    private String mOkButtonText;
    private String mCancelButtonText;
    private OnCloseListener mOnCloseListener;

    public OpenFileDialog(Context context) {
        super(context);
        this.init();
    }

    public OpenFileDialog(Context context, DialogInterface.OnCancelListener cancelListener) {
        super(context, true, cancelListener);
        this.init();
    }

    public OpenFileDialog(Context context, int themeResId) {
        super(context, themeResId);
        this.init();
    }

    private void init() {
        TypedValue typedValue = new TypedValue();
        this.getContext().getTheme().resolveAttribute(R.attr.colorPrimary, typedValue, true);
        this.mFileSelectedBackgroundColor = typedValue.data;
        this.mFileSelectedColor = -1;
        this.setPath(Environment.getExternalStorageDirectory().getAbsolutePath());
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.createView());
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.copyFrom(this.getWindow().getAttributes());
        layoutParams.width = -1;
        layoutParams.height = -1;
        this.getWindow().setAttributes(layoutParams);
    }

    private View createView() {
        LinearLayout layout2 = new LinearLayout(this.getContext());
        layout2.setOrientation(1);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        layout2.setLayoutParams(layoutParams);
        this.mTitleTextView = new TextView(this.getContext());
        LinearLayout.LayoutParams linearLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.mTitleTextView.setLayoutParams((ViewGroup.LayoutParams)linearLayoutParams);
        if (Build.VERSION.SDK_INT >= 23) {
            this.mTitleTextView.setTextAppearance(16974264);
        } else if (Build.VERSION.SDK_INT <= 14) {
            this.mTitleTextView.setTextAppearance(this.getContext(), 16974264);
        } else {
            this.mTitleTextView.setTextAppearance(this.getContext(), 16973890);
            this.mTitleTextView.setTypeface(null, 1);
        }
        int padding = OpenFileDialog.convertDpToPixels(16);
        this.mTitleTextView.setPadding(padding, padding, padding, padding);
        this.mTitleTextView.setText((CharSequence)this.mTitle);
        layout2.addView((View)this.mTitleTextView);
        if (this.mTitle == null) {
            this.mTitleTextView.setVisibility(8);
        }
        this.mPathTextView = new TextView(this.getContext());
        linearLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        if (Build.VERSION.SDK_INT >= 23) {
            this.mPathTextView.setTextAppearance(16973892);
        } else {
            this.mPathTextView.setTextAppearance(this.getContext(), 16973892);
        }
        this.mPathTextView.setLayoutParams((ViewGroup.LayoutParams)linearLayoutParams);
        padding = OpenFileDialog.convertDpToPixels(4);
        this.mPathTextView.setPadding(padding, padding, 0, 0);
        this.mPathTextView.setText((CharSequence)this.mPath);
        layout2.addView((View)this.mPathTextView);
        this.mFileListView = new RecyclerView(this.getContext());
        linearLayoutParams = new LinearLayout.LayoutParams(-1, -1, 1.0f);
        this.mFileListView.setLayoutParams((ViewGroup.LayoutParams)linearLayoutParams);
        layout2.addView((View)this.mFileListView);
        this.mFileListView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 1, false));
        this.mFileListAdapter = new FileListRecyclerViewAdapter();
        this.mFileListView.setAdapter((RecyclerView.Adapter)this.mFileListAdapter);
        LinearLayout buttonLayout = new LinearLayout(this.getContext());
        buttonLayout.setOrientation(0);
        linearLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        buttonLayout.setLayoutParams((ViewGroup.LayoutParams)linearLayoutParams);
        layout2.addView((View)buttonLayout);
        this.mOkButton = Build.VERSION.SDK_INT >= 11 ? new Button(this.getContext(), null, 16843563) : new Button(this.getContext());
        linearLayoutParams = new LinearLayout.LayoutParams(-1, -2, 1.0f);
        this.mOkButton.setLayoutParams((ViewGroup.LayoutParams)linearLayoutParams);
        if (this.mOkButtonText == null) {
            this.mOkButton.setText(17039370);
        } else {
            this.mOkButton.setText((CharSequence)this.mOkButtonText);
        }
        this.mOkButton.setEnabled(this.mFolderSelectable);
        this.mOkButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OpenFileDialog.this.dismiss();
                if (OpenFileDialog.this.mOnCloseListener != null) {
                    OpenFileDialog.this.mOnCloseListener.onOk(OpenFileDialog.this.getSelectedFile());
                }
            }
        });
        buttonLayout.addView((View)this.mOkButton);
        this.mCancelButton = Build.VERSION.SDK_INT >= 11 ? new Button(this.getContext(), null, 16843563) : new Button(this.getContext());
        linearLayoutParams = new LinearLayout.LayoutParams(-1, -2, 1.0f);
        this.mCancelButton.setLayoutParams((ViewGroup.LayoutParams)linearLayoutParams);
        if (this.mCancelButtonText == null) {
            this.mCancelButton.setText(0x1040000);
        } else {
            this.mCancelButton.setText((CharSequence)this.mCancelButtonText);
        }
        this.mCancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OpenFileDialog.this.mSelectedFile = null;
                OpenFileDialog.this.cancel();
                if (OpenFileDialog.this.mOnCloseListener != null) {
                    OpenFileDialog.this.mOnCloseListener.onCancel();
                }
            }
        });
        buttonLayout.addView((View)this.mCancelButton);
        return layout2;
    }

    public String getSelectedFile() {
        if (this.mFolderSelectable && this.mSelectedFile == null) {
            return this.mPath;
        }
        return this.mSelectedFile.absolutePath;
    }

    public OpenFileDialog setPath(String path) {
        this.mPath = path;
        if (this.mFileListAdapter != null) {
            this.mPathTextView.setText((CharSequence)path);
            if (!this.mPath.equals(File.separator)) {
                this.mFileListAdapter.mFileList.add(new FileItem("..", true));
            }
            this.mFileListAdapter.mFileList.addAll(new FileItem(this.mPath, true).listChildren());
            this.mFileListAdapter.notifyDataSetChanged();
        }
        return this;
    }

    public Button getOkButton() {
        return this.mOkButton;
    }

    public OpenFileDialog setOkButtonText(String text) {
        this.mOkButtonText = text;
        return this;
    }

    public Button getCancelButton() {
        return this.mCancelButton;
    }

    public OpenFileDialog setCancelButtonText(String text) {
        this.mCancelButtonText = text;
        return this;
    }

    public int getFileIcon() {
        return this.mFileIcon;
    }

    public OpenFileDialog setFileIcon(int fileIcon) {
        this.mFileIcon = fileIcon;
        return this;
    }

    public int getFolderIcon() {
        return this.mFolderIcon;
    }

    public OpenFileDialog setFolderIcon(int folderIcon) {
        this.mFolderIcon = folderIcon;
        return this;
    }

    public int getFolderUpIcon() {
        return this.mFolderUpIcon;
    }

    public OpenFileDialog setFolderUpIcon(int folderUpIcon) {
        this.mFolderUpIcon = folderUpIcon;
        return this;
    }

    public boolean isFolderSelectable() {
        return this.mFolderSelectable;
    }

    public OpenFileDialog setFolderSelectable(boolean folderSelectable) {
        this.mFolderSelectable = folderSelectable;
        return this;
    }

    public int getFileSelectedColor() {
        return this.mFileSelectedColor;
    }

    public OpenFileDialog setFileSelectedColor(int fileSelectedColor) {
        this.mFileSelectedColor = fileSelectedColor;
        return this;
    }

    public int getFileSelectedBackgroundColor() {
        return this.mFileSelectedBackgroundColor;
    }

    public OpenFileDialog setFileSelectedBackgroundColor(int fileSelectedBackgroundColor) {
        this.mFileSelectedBackgroundColor = fileSelectedBackgroundColor;
        return this;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(CharSequence title) {
        if (title != null) {
            this.mTitle = title.toString();
            if (this.mTitleTextView != null) {
                this.mTitleTextView.setVisibility(0);
            }
        }
    }

    public void setTitle(int titleId) {
        this.setTitle(this.getContext().getString(titleId));
    }

    public OpenFileDialog setOnCloseListener(OnCloseListener onCloseListener) {
        this.mOnCloseListener = onCloseListener;
        return this;
    }

    private static int convertDpToPixels(int dp) {
        return Math.round(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics()));
    }

    public static interface OnCloseListener {
        public void onCancel();

        public void onOk(String var1);
    }

    private class FileItem {
        String absolutePath;
        String name;
        boolean isDirectory;

        FileItem(String absolutePath, boolean isDirectory) {
            this.absolutePath = absolutePath;
            this.isDirectory = isDirectory;
            this.name = absolutePath.substring(absolutePath.lastIndexOf(File.separator) + 1);
        }

        List<FileItem> listChildren() {
            ArrayList<FileItem> list = new ArrayList<FileItem>();
            File parent = new File(this.absolutePath);
            if (parent.listFiles() == null) {
                return list;
            }
            File[] fileArr = parent.listFiles();
            Arrays.sort(fileArr, new Comparator<File>(){

                @Override
                public int compare(File lhs, File rhs) {
                    return lhs.getName().toLowerCase().compareTo(rhs.getName().toLowerCase());
                }
            });
            for (File file : fileArr) {
                if (file.getName().startsWith(".")) continue;
                list.add(new FileItem(file.getAbsolutePath(), file.isDirectory()));
            }
            return list;
        }
    }

    private class FileListRecyclerViewAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private List<FileItem> mFileList = new ArrayList<FileItem>();

        public FileListRecyclerViewAdapter() {
            if (OpenFileDialog.this.mPath != null) {
                if (!OpenFileDialog.this.mPath.equals(File.separator)) {
                    this.mFileList.add(new FileItem("..", true));
                }
                this.mFileList.addAll(new FileItem(OpenFileDialog.this.mPath, true).listChildren());
            }
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.open_file_dialog_item_layout, parent, false);
            return new ViewHolder(view);
        }

        public void onBindViewHolder(final ViewHolder holder, int position) {
            holder.mFileItem = this.mFileList.get(position);
            holder.mIconImageView.setImageResource(holder.mFileItem.name.equals("..") ? OpenFileDialog.this.mFolderUpIcon : (holder.mFileItem.isDirectory ? OpenFileDialog.this.mFolderIcon : OpenFileDialog.this.mFileIcon));
            if (Build.VERSION.SDK_INT >= 16) {
                holder.mIconImageView.setImageAlpha(138);
            }
            holder.mPathTextView.setText((CharSequence)holder.mFileItem.name);
            if (OpenFileDialog.this.mSelectedFile != null && ((OpenFileDialog)OpenFileDialog.this).mSelectedFile.absolutePath == holder.mFileItem.absolutePath && !OpenFileDialog.this.mFolderSelectable) {
                holder.mView.setBackgroundColor(OpenFileDialog.this.mFileSelectedBackgroundColor);
                holder.mPathTextView.setTextColor(OpenFileDialog.this.mFileSelectedColor);
            }
            holder.mView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (holder.mFileItem.isDirectory) {
                        OpenFileDialog.this.mSelectedFile = null;
                        FileListRecyclerViewAdapter.this.navigate(holder.mFileItem.name);
                        OpenFileDialog.this.mOkButton.setEnabled(OpenFileDialog.this.mFolderSelectable);
                    } else {
                        if (OpenFileDialog.this.mSelectedFile != null && holder.mFileItem.absolutePath == ((OpenFileDialog)OpenFileDialog.this).mSelectedFile.absolutePath) {
                            OpenFileDialog.this.mOkButton.setEnabled(false);
                            OpenFileDialog.this.mSelectedFile = null;
                        } else {
                            OpenFileDialog.this.mOkButton.setEnabled(true);
                            OpenFileDialog.this.mSelectedFile = holder.mFileItem;
                        }
                        FileListRecyclerViewAdapter.this.notifyDataSetChanged();
                    }
                }
            });
        }

        private void navigate(String fileName) {
            if (fileName.equals("..")) {
                if (OpenFileDialog.this.mPath.lastIndexOf(File.separator) == 0) {
                    OpenFileDialog.this.mPath = File.separator;
                } else {
                    OpenFileDialog.this.mPath = OpenFileDialog.this.mPath.substring(0, OpenFileDialog.this.mPath.lastIndexOf(File.separator));
                }
            } else {
                OpenFileDialog.this.mPath = OpenFileDialog.this.mPath + File.separator + fileName;
            }
            this.mFileList.clear();
            OpenFileDialog.this.mPathTextView.setText((CharSequence)OpenFileDialog.this.mPath);
            if (!OpenFileDialog.this.mPath.equals(File.separator)) {
                this.mFileList.add(new FileItem("..", true));
            }
            this.mFileList.addAll(new FileItem(OpenFileDialog.this.mPath, true).listChildren());
            OpenFileDialog.this.mFileListAdapter.notifyDataSetChanged();
        }

        public int getItemCount() {
            return this.mFileList.size();
        }

        public class ViewHolder
        extends RecyclerView.ViewHolder {
            public final View mView;
            public final ImageView mIconImageView;
            public final TextView mPathTextView;
            public FileItem mFileItem;

            public ViewHolder(View itemView) {
                super(itemView);
                this.mView = itemView;
                this.mIconImageView = (ImageView)itemView.findViewById(R.id.open_file_dialog_item_image_view);
                this.mPathTextView = (TextView)itemView.findViewById(R.id.open_file_dialog_item_text_view);
            }
        }
    }
}

