/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.format.validate.IPAddressProvider;
import inet.ipaddr.format.validate.ParsedHostIdentifierStringQualifier;
import java.io.Serializable;

public class ParsedHost
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final EmbeddedAddress NO_EMBEDDED_ADDRESS = new EmbeddedAddress();
    static final ParsedHostIdentifierStringQualifier NO_QUALIFIER = new ParsedHostIdentifierStringQualifier();
    private String[] normalizedLabels;
    private int[] separatorIndices;
    private boolean[] normalizedFlags;
    private final ParsedHostIdentifierStringQualifier labelsQualifier;
    private EmbeddedAddress embeddedAddress;
    String host;
    private final String originalStr;

    public ParsedHost(String originalStr, IPAddressProvider valueProvider) {
        this(originalStr, null, null, NO_QUALIFIER, new EmbeddedAddress());
        this.embeddedAddress.addressProvider = valueProvider;
    }

    public ParsedHost(String originalStr, IPAddressProvider valueProvider, ParsedHostIdentifierStringQualifier portQualifier) {
        this(originalStr, null, null, portQualifier, new EmbeddedAddress());
        this.embeddedAddress.addressProvider = valueProvider;
    }

    ParsedHost(String originalStr, int[] separatorIndices, boolean[] normalizedFlags, ParsedHostIdentifierStringQualifier labelsQualifier) {
        this(originalStr, separatorIndices, normalizedFlags, labelsQualifier, null);
    }

    ParsedHost(String originalStr, int[] separatorIndices, boolean[] normalizedFlags, ParsedHostIdentifierStringQualifier labelsQualifier, EmbeddedAddress embeddedAddress) {
        this.labelsQualifier = labelsQualifier;
        this.normalizedFlags = normalizedFlags;
        this.separatorIndices = separatorIndices;
        this.originalStr = originalStr;
        this.embeddedAddress = embeddedAddress == null ? NO_EMBEDDED_ADDRESS : embeddedAddress;
    }

    public boolean isIPv6Address() {
        return this.hasEmbeddedAddress() && this.getAddressProvider().isIPv6();
    }

    public Integer getPort() {
        return this.labelsQualifier.getPort();
    }

    public Integer getNetworkPrefixLength() {
        return this.labelsQualifier.getNetworkPrefixLength();
    }

    public Integer getEquivalentPrefixLength() {
        IPAddress mask;
        Integer pref = this.labelsQualifier.getNetworkPrefixLength();
        if (pref == null && (mask = this.getMask()) != null) {
            pref = mask.getMaskPrefixLength(true);
        }
        return pref;
    }

    public IPAddress getMask() {
        return this.labelsQualifier.getMask();
    }

    public IPAddressProvider getAddressProvider() {
        return this.embeddedAddress.addressProvider;
    }

    private boolean hasEmbeddedAddress() {
        return this.embeddedAddress.addressProvider != null;
    }

    public boolean isAddressString() {
        return this.getAddressProvider() != null;
    }

    public IPAddress asAddress(IPAddress.IPVersion version) {
        if (this.hasEmbeddedAddress()) {
            return this.getAddressProvider().getAddress(version);
        }
        return null;
    }

    public IPAddress asAddress() {
        if (this.hasEmbeddedAddress()) {
            return this.getAddressProvider().getAddress();
        }
        return null;
    }

    public IPAddressString asGenericAddressString() {
        if (this.hasEmbeddedAddress()) {
            IPAddressProvider addressProvider = this.getAddressProvider();
            if (addressProvider.isAllAddresses()) {
                return IPAddressString.ALL_ADDRESSES;
            }
            if (addressProvider.isPrefixOnly()) {
                return IPAddressNetwork.getPrefix(addressProvider.getNetworkPrefixLength());
            }
            if (addressProvider.isEmpty()) {
                return IPAddressString.EMPTY_ADDRESS;
            }
            return this.getAddressProvider().getAddress().toAddressString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNormalizedLabels() {
        String[] labels = this.normalizedLabels;
        if (labels == null) {
            ParsedHost parsedHost = this;
            synchronized (parsedHost) {
                labels = this.normalizedLabels;
                if (labels == null) {
                    if (this.hasEmbeddedAddress()) {
                        IPAddressProvider addressProvider = this.getAddressProvider();
                        IPAddress addr = addressProvider.getAddress();
                        if (addr == null) {
                            if (addressProvider.isEmpty()) {
                                return new String[0];
                            }
                            return new String[]{this.asGenericAddressString().toString()};
                        }
                        labels = addr.getSegmentStrings();
                    } else {
                        labels = new String[this.separatorIndices.length];
                        int i = 0;
                        int lastSep = -1;
                        while (i < labels.length) {
                            int index = this.separatorIndices[i];
                            if (this.normalizedFlags != null && !this.normalizedFlags[i]) {
                                StringBuilder second = new StringBuilder(index - lastSep - 1);
                                int j = lastSep + 1;
                                while (j < index) {
                                    char c = this.originalStr.charAt(j);
                                    second.append(c >= 'A' && c <= 'Z' ? (char)(c + 32) : c);
                                    ++j;
                                }
                                labels[i] = second.toString();
                            } else {
                                labels[i] = this.originalStr.substring(lastSep + 1, index);
                            }
                            lastSep = index;
                            ++i;
                        }
                        this.separatorIndices = null;
                        this.normalizedFlags = null;
                    }
                    this.normalizedLabels = labels;
                }
            }
        }
        return labels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHost() {
        String str = this.host;
        if (str == null) {
            if (this.originalStr.length() > 0) {
                ParsedHost parsedHost = this;
                synchronized (parsedHost) {
                    str = this.host;
                    if (str == null) {
                        if (this.hasEmbeddedAddress()) {
                            IPAddressProvider addressProvider = this.getAddressProvider();
                            IPAddress addr = addressProvider.getAddress();
                            if (addr == null) {
                                return this.asGenericAddressString().toString();
                            }
                            return addr.getSection().toNormalizedWildcardString();
                        }
                        StringBuilder builder = new StringBuilder(this.originalStr.length());
                        String[] labels = this.getNormalizedLabels();
                        builder.append(labels[0]);
                        int i = 1;
                        while (i < labels.length) {
                            builder.append('.').append(labels[i]);
                            ++i;
                        }
                        str = builder.toString();
                    }
                }
            } else {
                str = this.originalStr;
            }
            this.host = str;
        }
        return str;
    }

    public AddressStringException getAddressStringException() {
        return this.embeddedAddress.addressStringException;
    }

    public boolean isUNCIPv6Literal() {
        return this.embeddedAddress.isUNCIPv6Literal;
    }

    public boolean isReverseDNS() {
        return this.embeddedAddress.isReverseDNS;
    }

    static class EmbeddedAddress
    implements Serializable {
        private static final long serialVersionUID = 3L;
        boolean isUNCIPv6Literal;
        boolean isReverseDNS;
        AddressStringException addressStringException;
        IPAddressProvider addressProvider;

        EmbeddedAddress() {
        }
    }
}

