/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.format.validate.ParsedMACAddress;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressSegment;
import java.io.Serializable;

public class MACAddressProvider
implements Serializable {
    private static final long serialVersionUID = 3L;
    private ParsedMACAddress parsedAddress;
    private MACAddress address;
    static final MACAddressProvider EMPTY_PROVIDER = new MACAddressProvider(){
        private static final long serialVersionUID = 3L;

        @Override
        public MACAddress getAddress() {
            return null;
        }
    };
    private static final MACAddress ALL_MAC_ADDRESSES = new MACAddress(new MACAddressSegment[]{MACAddressSegment.ALL_RANGE_SEGMENT, MACAddressSegment.ALL_RANGE_SEGMENT, MACAddressSegment.ALL_RANGE_SEGMENT, MACAddressSegment.ALL_RANGE_SEGMENT, MACAddressSegment.ALL_RANGE_SEGMENT, MACAddressSegment.ALL_RANGE_SEGMENT});
    static final MACAddressProvider ALL_MAC = new MACAddressProvider(){
        private static final long serialVersionUID = 3L;

        @Override
        public MACAddress getAddress() {
            return ALL_MAC_ADDRESSES;
        }
    };
    private static final MACAddress ALL_EUI_64_ADDRESSES = new MACAddress(new MACAddressSegment[]{MACAddressSegment.ALL_RANGE_SEGMENT, MACAddressSegment.ALL_RANGE_SEGMENT, MACAddressSegment.ALL_RANGE_SEGMENT, MACAddressSegment.ALL_RANGE_SEGMENT, MACAddressSegment.ALL_RANGE_SEGMENT, MACAddressSegment.ALL_RANGE_SEGMENT, MACAddressSegment.ALL_RANGE_SEGMENT, MACAddressSegment.ALL_RANGE_SEGMENT});
    static final MACAddressProvider ALL_EUI_64 = new MACAddressProvider(){
        private static final long serialVersionUID = 3L;

        @Override
        public MACAddress getAddress() {
            return ALL_EUI_64_ADDRESSES;
        }
    };

    private MACAddressProvider() {
    }

    public MACAddressProvider(ParsedMACAddress parsedAddress) {
        this.parsedAddress = parsedAddress;
    }

    public MACAddressProvider(MACAddress address) {
        this.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MACAddress getAddress() {
        if (this.parsedAddress != null) {
            MACAddressProvider mACAddressProvider = this;
            synchronized (mACAddressProvider) {
                if (this.parsedAddress != null) {
                    this.address = this.parsedAddress.createAddress();
                    this.parsedAddress = null;
                }
            }
        }
        return this.address;
    }

    public String toString() {
        return String.valueOf(this.getAddress());
    }

    /* synthetic */ MACAddressProvider(MACAddressProvider mACAddressProvider) {
        this();
    }
}

