/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.junit.jupiter.internal.filter;

import com.github.sbt.junit.jupiter.internal.event.Dispatcher;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.PostDiscoveryFilter;

public class GlobFilter
implements PostDiscoveryFilter {
    private final Dispatcher eventDispatcher;
    private final List<Pattern> patterns;

    GlobFilter(Set<String> set, Dispatcher dispatcher) {
        this.eventDispatcher = dispatcher;
        this.patterns = set.stream().map(this::compile).collect(Collectors.toList());
    }

    public static Optional<GlobFilter> create(Set<String> set, Dispatcher dispatcher) {
        if (set.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new GlobFilter(set, dispatcher));
    }

    public FilterResult apply(TestDescriptor testDescriptor) {
        String string = this.toTestName(testDescriptor.getUniqueId());
        return this.findMatchingPattern(string).map(pattern -> FilterResult.included((String)"")).orElseGet(() -> {
            this.eventDispatcher.executionFiltered(testDescriptor, "because");
            return FilterResult.excluded((String)"");
        });
    }

    String toTestName(UniqueId uniqueId) {
        return uniqueId.getSegments().stream().skip(1L).map(UniqueId.Segment::getValue).collect(Collectors.joining("."));
    }

    Optional<Pattern> findMatchingPattern(String string) {
        return this.patterns.stream().filter(pattern -> pattern.matcher(string).matches()).findAny();
    }

    private Pattern compile(String string) {
        String[] stringArray = string.split("\\*", -1);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (0 != i) {
                stringBuilder.append(".*");
            }
            if (stringArray[i].isEmpty()) continue;
            stringBuilder.append(Pattern.quote(stringArray[i].replaceAll("\n", "\\n")));
        }
        return Pattern.compile(stringBuilder.toString());
    }
}

